/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.kafka.listener.KafkaExceptionLogLevelAware;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.handler.invocation.MethodArgumentResolutionException;
import org.springframework.util.Assert;

public abstract class ExceptionClassifier
extends KafkaExceptionLogLevelAware {
    private ExtendedBinaryExceptionClassifier classifier = ExceptionClassifier.configureDefaultClassifier(true);

    public static List<Class<? extends Throwable>> defaultFatalExceptionsList() {
        return Arrays.asList(DeserializationException.class, MessageConversionException.class, ConversionException.class, MethodArgumentResolutionException.class, NoSuchMethodException.class, ClassCastException.class);
    }

    private static ExtendedBinaryExceptionClassifier configureDefaultClassifier(boolean defaultClassification) {
        return new ExtendedBinaryExceptionClassifier(ExceptionClassifier.defaultFatalExceptionsList().stream().collect(Collectors.toMap(ex -> ex, ex -> false)), defaultClassification);
    }

    public void defaultFalse(boolean retainStandardFatal) {
        if (retainStandardFatal) {
            this.classifier = ExceptionClassifier.configureDefaultClassifier(false);
        } else {
            this.defaultFalse();
        }
    }

    public void defaultFalse() {
        this.classifier = new ExtendedBinaryExceptionClassifier(new HashMap<Class<? extends Throwable>, Boolean>(), false);
    }

    protected BinaryExceptionClassifier getClassifier() {
        return this.classifier;
    }

    public void setClassifications(Map<Class<? extends Throwable>, Boolean> classifications, boolean defaultValue) {
        Assert.notNull(classifications, (String)"'classifications' + cannot be null");
        this.classifier = new ExtendedBinaryExceptionClassifier(classifications, defaultValue);
    }

    @SafeVarargs
    public final void addNotRetryableExceptions(Class<? extends Exception> ... exceptionTypes) {
        this.add(false, exceptionTypes);
        this.notRetryable(Arrays.stream(exceptionTypes));
    }

    protected void notRetryable(Stream<Class<? extends Exception>> notRetryable) {
    }

    @SafeVarargs
    public final void addRetryableExceptions(Class<? extends Exception> ... exceptionTypes) {
        this.add(true, exceptionTypes);
    }

    @SafeVarargs
    private void add(boolean classified, Class<? extends Exception> ... exceptionTypes) {
        Assert.notNull(exceptionTypes, (String)"'exceptionTypes' cannot be null");
        Assert.noNullElements((Object[])exceptionTypes, (String)"'exceptionTypes' cannot contain nulls");
        for (Class<? extends Exception> exceptionType : exceptionTypes) {
            Assert.isTrue((boolean)Exception.class.isAssignableFrom(exceptionType), () -> "exceptionType " + String.valueOf(exceptionType) + " must be an Exception");
            this.classifier.getClassified().put(exceptionType, classified);
        }
    }

    @Nullable
    public Boolean removeClassification(Class<? extends Exception> exceptionType) {
        return this.classifier.getClassified().remove(exceptionType);
    }

    private static final class ExtendedBinaryExceptionClassifier
    extends BinaryExceptionClassifier {
        ExtendedBinaryExceptionClassifier(Map<Class<? extends Throwable>, Boolean> typeMap, boolean defaultValue) {
            super(typeMap, defaultValue);
            this.setTraverseCauses(true);
        }

        protected Map<Class<? extends Throwable>, Boolean> getClassified() {
            return super.getClassified();
        }
    }
}

