/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.kafka.KafkaClientMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.producer.Producer;
import org.springframework.kafka.core.ProducerFactory;

public class MicrometerProducerListener<K, V>
implements ProducerFactory.Listener<K, V> {
    private final MeterRegistry meterRegistry;
    private final List<Tag> tags;
    private final Map<String, KafkaClientMetrics> metrics = new HashMap<String, KafkaClientMetrics>();

    public MicrometerProducerListener(MeterRegistry meterRegistry) {
        this(meterRegistry, Collections.emptyList());
    }

    public MicrometerProducerListener(MeterRegistry meterRegistry, List<Tag> tags) {
        this.meterRegistry = meterRegistry;
        this.tags = tags;
    }

    @Override
    public synchronized void producerAdded(String id, Producer<K, V> producer) {
        if (!this.metrics.containsKey(id)) {
            ArrayList<Tag> producerTags = new ArrayList<Tag>(this.tags);
            producerTags.add((Tag)new ImmutableTag("spring.id", id));
            this.metrics.put(id, new KafkaClientMetrics(producer, producerTags));
            this.metrics.get(id).bindTo(this.meterRegistry);
        }
    }

    @Override
    public synchronized void producerRemoved(String id, Producer<K, V> producer) {
        KafkaClientMetrics removed = this.metrics.remove(id);
        if (removed != null) {
            removed.close();
        }
    }
}

