/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.requestreply;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.springframework.kafka.support.SendResult;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;

public class RequestReplyMessageFuture<K, V>
extends SettableListenableFuture<Message<?>> {
    protected final ListenableFuture<SendResult<K, V>> sendFuture;
    protected CompletableFuture<SendResult<K, V>> completableSendFuture;
    private Completable completable;

    RequestReplyMessageFuture(ListenableFuture<SendResult<K, V>> sendFuture) {
        this.sendFuture = sendFuture;
    }

    public ListenableFuture<SendResult<K, V>> getSendFuture() {
        return this.sendFuture;
    }

    public synchronized Completable asCompletable() {
        if (this.completable == null) {
            this.completable = new Completable((Future<Message<?>>)((Object)this));
            this.addCallback(this.completable::complete, this.completable::completeExceptionally);
        }
        return this.completable;
    }

    public class Completable
    extends CompletableFuture<Message<?>> {
        private final Future<Message<?>> delegate;

        Completable(Future<Message<?>> delegate) {
            Assert.notNull(delegate, (String)"Delegate must not be null");
            this.delegate = delegate;
        }

        public synchronized CompletableFuture<SendResult<K, V>> getSendFuture() {
            if (RequestReplyMessageFuture.this.completableSendFuture == null) {
                RequestReplyMessageFuture.this.completableSendFuture = RequestReplyMessageFuture.this.sendFuture.completable();
            }
            return RequestReplyMessageFuture.this.completableSendFuture;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result = this.delegate.cancel(mayInterruptIfRunning);
            super.cancel(mayInterruptIfRunning);
            return result;
        }
    }
}

