/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.time.Clock;
import org.springframework.core.task.TaskExecutor;
import org.springframework.kafka.listener.AbstractKafkaBackOffManagerFactory;
import org.springframework.kafka.listener.KafkaConsumerBackoffManager;
import org.springframework.kafka.listener.KafkaConsumerTimingAdjuster;
import org.springframework.kafka.listener.ListenerContainerRegistry;
import org.springframework.kafka.listener.PartitionPausingBackoffManager;
import org.springframework.kafka.listener.WakingKafkaConsumerTimingAdjuster;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.Assert;

public class PartitionPausingBackOffManagerFactory
extends AbstractKafkaBackOffManagerFactory {
    private boolean timingAdjustmentEnabled = true;
    private KafkaConsumerTimingAdjuster timingAdjustmentManager;
    private TaskExecutor taskExecutor;
    private final Clock clock;

    public PartitionPausingBackOffManagerFactory(KafkaConsumerTimingAdjuster timingAdjustmentManager) {
        this.clock = this.getDefaultClock();
        this.setTimingAdjustmentManager(timingAdjustmentManager);
    }

    public PartitionPausingBackOffManagerFactory(TaskExecutor timingAdjustmentManagerTaskExecutor) {
        this.clock = this.getDefaultClock();
        this.setTaskExecutor(timingAdjustmentManagerTaskExecutor);
    }

    public PartitionPausingBackOffManagerFactory(boolean timingAdjustmentEnabled) {
        this.clock = this.getDefaultClock();
        this.setTimingAdjustmentEnabled(timingAdjustmentEnabled);
    }

    public PartitionPausingBackOffManagerFactory(ListenerContainerRegistry listenerContainerRegistry) {
        super(listenerContainerRegistry);
        this.clock = this.getDefaultClock();
    }

    public PartitionPausingBackOffManagerFactory() {
        this.clock = this.getDefaultClock();
    }

    public PartitionPausingBackOffManagerFactory(Clock clock) {
        this.clock = clock;
    }

    public final void setTimingAdjustmentEnabled(boolean timingAdjustmentEnabled) {
        this.timingAdjustmentEnabled = timingAdjustmentEnabled;
    }

    public final void setTimingAdjustmentManager(KafkaConsumerTimingAdjuster timingAdjustmentManager) {
        Assert.isTrue((boolean)this.timingAdjustmentEnabled, () -> "TimingAdjustment is disabled for this factory.");
        this.timingAdjustmentManager = timingAdjustmentManager;
    }

    public final void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.isTrue((boolean)this.timingAdjustmentEnabled, () -> "TimingAdjustment is disabled for this factory.");
        this.taskExecutor = taskExecutor;
    }

    @Override
    protected KafkaConsumerBackoffManager doCreateManager(ListenerContainerRegistry registry) {
        PartitionPausingBackoffManager kafkaConsumerBackoffManager = this.getKafkaConsumerBackoffManager(registry);
        super.addApplicationListener(kafkaConsumerBackoffManager);
        return kafkaConsumerBackoffManager;
    }

    protected final Clock getDefaultClock() {
        return Clock.systemUTC();
    }

    private PartitionPausingBackoffManager getKafkaConsumerBackoffManager(ListenerContainerRegistry registry) {
        return this.timingAdjustmentEnabled ? new PartitionPausingBackoffManager(registry, this.getOrCreateBackOffTimingAdjustmentManager(), this.clock) : new PartitionPausingBackoffManager(registry, this.clock);
    }

    private KafkaConsumerTimingAdjuster getOrCreateBackOffTimingAdjustmentManager() {
        if (this.timingAdjustmentManager != null) {
            return this.timingAdjustmentManager;
        }
        return new WakingKafkaConsumerTimingAdjuster(this.getOrCreateTimingAdjustmentThreadExecutor());
    }

    private TaskExecutor getOrCreateTimingAdjustmentThreadExecutor() {
        if (this.taskExecutor != null) {
            return this.taskExecutor;
        }
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.initialize();
        super.addApplicationListener(event -> executor.shutdown());
        return executor;
    }
}

