/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.kafka.listener.ContainerAwareBatchErrorHandler;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConditionalDelegatingBatchErrorHandler
implements ContainerAwareBatchErrorHandler {
    private final ContainerAwareBatchErrorHandler defaultErrorHandler;
    private final Map<Class<? extends Throwable>, ContainerAwareBatchErrorHandler> delegates = new LinkedHashMap<Class<? extends Throwable>, ContainerAwareBatchErrorHandler>();

    public ConditionalDelegatingBatchErrorHandler(ContainerAwareBatchErrorHandler defaultErrorHandler) {
        Assert.notNull((Object)defaultErrorHandler, (String)"'defaultErrorHandler' cannot be null");
        this.defaultErrorHandler = defaultErrorHandler;
    }

    public void setErrorHandlers(Map<Class<? extends Throwable>, ContainerAwareBatchErrorHandler> delegates) {
        this.delegates.clear();
        this.delegates.putAll(delegates);
    }

    public void addDelegate(Class<? extends Throwable> throwable, ContainerAwareBatchErrorHandler handler) {
        this.delegates.put(throwable, handler);
    }

    @Override
    public void handle(Exception thrownException, ConsumerRecords<?, ?> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        this.doHandle(thrownException, records, consumer, container, null);
    }

    @Override
    public void handle(Exception thrownException, ConsumerRecords<?, ?> records, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        this.doHandle(thrownException, records, consumer, container, invokeListener);
    }

    protected void doHandle(Exception thrownException, ConsumerRecords<?, ?> records, Consumer<?, ?> consumer, MessageListenerContainer container, @Nullable Runnable invokeListener) {
        Throwable cause = thrownException;
        if (cause instanceof ListenerExecutionFailedException) {
            cause = thrownException.getCause();
        }
        if (cause != null) {
            Class<?> causeClass = cause.getClass();
            for (Map.Entry<Class<? extends Throwable>, ContainerAwareBatchErrorHandler> entry : this.delegates.entrySet()) {
                if (!entry.getKey().isAssignableFrom(causeClass)) continue;
                entry.getValue().handle(thrownException, records, consumer, container, invokeListener);
                return;
            }
        }
        this.defaultErrorHandler.handle(thrownException, records, consumer, container, invokeListener);
    }
}

