/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.annotation;

import java.io.IOException;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.log.LogAccessor;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.kafka.annotation.KafkaHandler;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.annotation.KafkaListenerConfigurer;
import org.springframework.kafka.annotation.KafkaListeners;
import org.springframework.kafka.annotation.KafkaNullAwarePayloadArgumentResolver;
import org.springframework.kafka.annotation.PartitionOffset;
import org.springframework.kafka.annotation.RetryTopicConfigurationProvider;
import org.springframework.kafka.annotation.TopicPartition;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpointRegistrar;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.kafka.config.MethodKafkaListenerEndpoint;
import org.springframework.kafka.config.MultiMethodKafkaListenerEndpoint;
import org.springframework.kafka.listener.ContainerGroupSequencer;
import org.springframework.kafka.listener.KafkaListenerErrorHandler;
import org.springframework.kafka.retrytopic.RetryTopicBootstrapper;
import org.springframework.kafka.retrytopic.RetryTopicConfiguration;
import org.springframework.kafka.retrytopic.RetryTopicConfigurer;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.GenericMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Validator;

public class KafkaListenerAnnotationBeanPostProcessor<K, V>
implements BeanPostProcessor,
Ordered,
ApplicationContextAware,
InitializingBean,
SmartInitializingSingleton {
    private static final String GENERATED_ID_PREFIX = "org.springframework.kafka.KafkaListenerEndpointContainer#";
    public static final String DEFAULT_KAFKA_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "kafkaListenerContainerFactory";
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final ListenerScope listenerScope = new ListenerScope();
    private final KafkaHandlerMethodFactoryAdapter messageHandlerMethodFactory = new KafkaHandlerMethodFactoryAdapter();
    private final KafkaListenerEndpointRegistrar registrar = new KafkaListenerEndpointRegistrar();
    private final AtomicInteger counter = new AtomicInteger();
    private KafkaListenerEndpointRegistry endpointRegistry;
    private String defaultContainerFactoryBeanName = "kafkaListenerContainerFactory";
    private ApplicationContext applicationContext;
    private BeanFactory beanFactory;
    private BeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    private BeanExpressionContext expressionContext;
    private Charset charset = StandardCharsets.UTF_8;
    private AnnotationEnhancer enhancer;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setEndpointRegistry(KafkaListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public void setDefaultContainerFactoryBeanName(String containerFactoryBeanName) {
        this.defaultContainerFactoryBeanName = containerFactoryBeanName;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory.setHandlerMethodFactory(messageHandlerMethodFactory);
    }

    public MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
        return this.messageHandlerMethodFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.setBeanFactory((BeanFactory)((ConfigurableApplicationContext)applicationContext).getBeanFactory());
        } else {
            this.setBeanFactory((BeanFactory)applicationContext);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), (Scope)this.listenerScope);
        }
    }

    public void setCharset(Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' cannot be null");
        this.charset = charset;
    }

    public void afterPropertiesSet() throws Exception {
        this.buildEnhancer();
    }

    public void afterSingletonsInstantiated() {
        MessageHandlerMethodFactory handlerMethodFactory;
        this.registrar.setBeanFactory(this.beanFactory);
        if (this.beanFactory instanceof ListableBeanFactory) {
            Map instances = ((ListableBeanFactory)this.beanFactory).getBeansOfType(KafkaListenerConfigurer.class);
            for (KafkaListenerConfigurer configurer : instances.values()) {
                configurer.configureKafkaListeners(this.registrar);
            }
        }
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (KafkaListenerEndpointRegistry)this.beanFactory.getBean("org.springframework.kafka.config.internalKafkaListenerEndpointRegistry", KafkaListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if (this.defaultContainerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.defaultContainerFactoryBeanName);
        }
        if ((handlerMethodFactory = this.registrar.getMessageHandlerMethodFactory()) != null) {
            this.messageHandlerMethodFactory.setHandlerMethodFactory(handlerMethodFactory);
        } else {
            this.addFormatters((FormatterRegistry)this.messageHandlerMethodFactory.defaultFormattingConversionService);
        }
        this.registrar.afterPropertiesSet();
        Map sequencers = this.applicationContext.getBeansOfType(ContainerGroupSequencer.class, false, false);
        sequencers.values().forEach(seq -> seq.initialize());
    }

    private void buildEnhancer() {
        Map enhancersMap;
        if (this.applicationContext != null && (enhancersMap = this.applicationContext.getBeansOfType(AnnotationEnhancer.class, false, false)).size() > 0) {
            List enhancers = enhancersMap.values().stream().sorted(new OrderComparator()).collect(Collectors.toList());
            this.enhancer = (attrs, element) -> {
                Map newAttrs = attrs;
                for (AnnotationEnhancer enh : enhancers) {
                    newAttrs = (Map)enh.apply(newAttrs, element);
                }
                return attrs;
            };
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            Collection<KafkaListener> classLevelListeners = this.findListenerAnnotations(targetClass);
            boolean hasClassLevelListeners = classLevelListeners.size() > 0;
            ArrayList<Method> multiMethods = new ArrayList<Method>();
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> {
                Set<KafkaListener> listenerMethods = this.findListenerAnnotations(method);
                return !listenerMethods.isEmpty() ? listenerMethods : null;
            });
            if (hasClassLevelListeners) {
                Set methodsWithHandler = MethodIntrospector.selectMethods((Class)targetClass, method -> AnnotationUtils.findAnnotation((Method)method, KafkaHandler.class) != null);
                multiMethods.addAll(methodsWithHandler);
            }
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(bean.getClass());
                this.logger.trace(() -> "No @KafkaListener annotations found on bean type: " + bean.getClass());
            } else {
                for (Map.Entry entry : annotatedMethods.entrySet()) {
                    Method method2 = (Method)entry.getKey();
                    for (KafkaListener listener : (Set)entry.getValue()) {
                        this.processKafkaListener(listener, method2, bean, beanName);
                    }
                }
                this.logger.debug(() -> annotatedMethods.size() + " @KafkaListener methods processed on bean '" + beanName + "': " + annotatedMethods);
            }
            if (hasClassLevelListeners) {
                this.processMultiMethodListeners(classLevelListeners, multiMethods, bean, beanName);
            }
        }
        return bean;
    }

    private Collection<KafkaListener> findListenerAnnotations(Class<?> clazz) {
        KafkaListeners anns;
        HashSet<KafkaListener> listeners = new HashSet<KafkaListener>();
        KafkaListener ann = (KafkaListener)AnnotatedElementUtils.findMergedAnnotation(clazz, KafkaListener.class);
        if (ann != null) {
            ann = this.enhance(clazz, ann);
            listeners.add(ann);
        }
        if ((anns = (KafkaListeners)AnnotationUtils.findAnnotation(clazz, KafkaListeners.class)) != null) {
            listeners.addAll(Arrays.stream(anns.value()).map(anno -> this.enhance(clazz, (KafkaListener)anno)).collect(Collectors.toList()));
        }
        return listeners;
    }

    private Set<KafkaListener> findListenerAnnotations(Method method) {
        KafkaListeners anns;
        HashSet<KafkaListener> listeners = new HashSet<KafkaListener>();
        KafkaListener ann = (KafkaListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, KafkaListener.class);
        if (ann != null) {
            ann = this.enhance(method, ann);
            listeners.add(ann);
        }
        if ((anns = (KafkaListeners)AnnotationUtils.findAnnotation((Method)method, KafkaListeners.class)) != null) {
            listeners.addAll(Arrays.stream(anns.value()).map(anno -> this.enhance(method, (KafkaListener)anno)).collect(Collectors.toList()));
        }
        return listeners;
    }

    private KafkaListener enhance(AnnotatedElement element, KafkaListener ann) {
        if (this.enhancer == null) {
            return ann;
        }
        return (KafkaListener)AnnotationUtils.synthesizeAnnotation((Map)((Map)this.enhancer.apply(AnnotationUtils.getAnnotationAttributes((Annotation)ann), element)), KafkaListener.class, null);
    }

    private void processMultiMethodListeners(Collection<KafkaListener> classLevelListeners, List<Method> multiMethods, Object bean, String beanName) {
        ArrayList<Method> checkedMethods = new ArrayList<Method>();
        Method defaultMethod = null;
        for (Method method : multiMethods) {
            Method checked = this.checkProxy(method, bean);
            KafkaHandler annotation = (KafkaHandler)AnnotationUtils.findAnnotation((Method)method, KafkaHandler.class);
            if (annotation != null && annotation.isDefault()) {
                Method toAssert = defaultMethod;
                Assert.state((toAssert == null ? 1 : 0) != 0, () -> "Only one @KafkaHandler can be marked 'isDefault', found: " + toAssert.toString() + " and " + method.toString());
                defaultMethod = checked;
            }
            checkedMethods.add(checked);
        }
        for (KafkaListener classLevelListener : classLevelListeners) {
            MultiMethodKafkaListenerEndpoint endpoint = new MultiMethodKafkaListenerEndpoint(checkedMethods, defaultMethod, bean);
            this.processListener(endpoint, classLevelListener, bean, beanName);
        }
    }

    protected void processKafkaListener(KafkaListener kafkaListener, Method method, Object bean, String beanName) {
        Method methodToUse = this.checkProxy(method, bean);
        MethodKafkaListenerEndpoint endpoint = new MethodKafkaListenerEndpoint();
        endpoint.setMethod(methodToUse);
        if (!this.processMainAndRetryListeners(kafkaListener, bean, beanName, methodToUse, endpoint)) {
            this.processListener(endpoint, kafkaListener, bean, beanName);
        }
    }

    private boolean processMainAndRetryListeners(KafkaListener kafkaListener, Object bean, String beanName, Method methodToUse, MethodKafkaListenerEndpoint<K, V> endpoint) {
        RetryTopicConfiguration retryTopicConfiguration = new RetryTopicConfigurationProvider(this.beanFactory, this.resolver, this.expressionContext).findRetryConfigurationFor(kafkaListener.topics(), methodToUse, bean);
        if (retryTopicConfiguration == null) {
            this.logger.debug((CharSequence)("No retry topic configuration found for topics " + Arrays.asList(kafkaListener.topics())));
            return false;
        }
        RetryTopicConfigurer.EndpointProcessor endpointProcessor = endpointToProcess -> this.processKafkaListenerAnnotationForRetryTopic((MethodKafkaListenerEndpoint<?, ?>)endpointToProcess, kafkaListener, bean);
        String beanRef = kafkaListener.beanRef();
        this.listenerScope.addListener(beanRef, bean);
        KafkaListenerContainerFactory<?> factory = this.resolveContainerFactory(kafkaListener, this.resolve(kafkaListener.containerFactory()), beanName);
        this.getRetryTopicConfigurer().processMainAndRetryListeners(endpointProcessor, endpoint, retryTopicConfiguration, this.registrar, factory, this.defaultContainerFactoryBeanName);
        this.listenerScope.removeListener(beanRef);
        return true;
    }

    private RetryTopicConfigurer getRetryTopicConfigurer() {
        this.bootstrapRetryTopicIfNecessary();
        return (RetryTopicConfigurer)this.beanFactory.getBean("internalRetryTopicConfigurer", RetryTopicConfigurer.class);
    }

    private void bootstrapRetryTopicIfNecessary() {
        if (!(this.beanFactory instanceof BeanDefinitionRegistry)) {
            throw new IllegalStateException("BeanFactory must be an instance of " + BeanDefinitionRegistry.class.getSimpleName() + " to bootstrap the RetryTopic functionality. Provided beanFactory: " + this.beanFactory.getClass().getSimpleName());
        }
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.beanFactory;
        if (!registry.containsBeanDefinition("internalRetryTopicBootstrapper")) {
            registry.registerBeanDefinition("internalRetryTopicBootstrapper", (BeanDefinition)new RootBeanDefinition(RetryTopicBootstrapper.class));
            ((RetryTopicBootstrapper)this.beanFactory.getBean("internalRetryTopicBootstrapper", RetryTopicBootstrapper.class)).bootstrapRetryTopic();
        }
    }

    private Method checkProxy(Method methodArg, Object bean) {
        Method method = methodArg;
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                Class[] proxiedInterfaces;
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                for (Class iface : proxiedInterfaces = ((Advised)bean).getProxiedInterfaces()) {
                    try {
                        method = iface.getMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@KafkaListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()), ex);
            }
        }
        return method;
    }

    protected void processListener(MethodKafkaListenerEndpoint<?, ?> endpoint, KafkaListener kafkaListener, Object bean, String beanName) {
        String beanRef = kafkaListener.beanRef();
        if (StringUtils.hasText((String)beanRef)) {
            this.listenerScope.addListener(beanRef, bean);
        }
        this.processKafkaListenerAnnotationBeforeRegistration(endpoint, kafkaListener, bean);
        String containerFactory = this.resolve(kafkaListener.containerFactory());
        KafkaListenerContainerFactory<?> listenerContainerFactory = this.resolveContainerFactory(kafkaListener, containerFactory, beanName);
        this.registrar.registerEndpoint(endpoint, listenerContainerFactory);
        this.processKafkaListenerEndpointAfterRegistration(endpoint, kafkaListener);
        if (StringUtils.hasText((String)beanRef)) {
            this.listenerScope.removeListener(beanRef);
        }
    }

    private void processKafkaListenerAnnotationForRetryTopic(MethodKafkaListenerEndpoint<?, ?> endpoint, KafkaListener kafkaListener, Object bean) {
        this.processKafkaListenerAnnotationBeforeRegistration(endpoint, kafkaListener, bean);
        this.processKafkaListenerEndpointAfterRegistration(endpoint, kafkaListener);
    }

    private void processKafkaListenerAnnotationBeforeRegistration(MethodKafkaListenerEndpoint<?, ?> endpoint, KafkaListener kafkaListener, Object bean) {
        String autoStartup;
        String concurrency;
        Object resolvedGroup;
        endpoint.setBean(bean);
        endpoint.setMessageHandlerMethodFactory(this.messageHandlerMethodFactory);
        endpoint.setId(this.getEndpointId(kafkaListener));
        endpoint.setGroupId(this.getEndpointGroupId(kafkaListener, endpoint.getId()));
        endpoint.setTopicPartitions(this.resolveTopicPartitions(kafkaListener));
        endpoint.setTopics(this.resolveTopics(kafkaListener));
        endpoint.setTopicPattern(this.resolvePattern(kafkaListener));
        endpoint.setClientIdPrefix(this.resolveExpressionAsString(kafkaListener.clientIdPrefix(), "clientIdPrefix"));
        String group = kafkaListener.containerGroup();
        if (StringUtils.hasText((String)group) && (resolvedGroup = this.resolveExpression(group)) instanceof String) {
            endpoint.setGroup((String)resolvedGroup);
        }
        if (StringUtils.hasText((String)(concurrency = kafkaListener.concurrency()))) {
            endpoint.setConcurrency(this.resolveExpressionAsInteger(concurrency, "concurrency"));
        }
        if (StringUtils.hasText((String)(autoStartup = kafkaListener.autoStartup()))) {
            endpoint.setAutoStartup(this.resolveExpressionAsBoolean(autoStartup, "autoStartup"));
        }
        this.resolveKafkaProperties(endpoint, kafkaListener.properties());
        endpoint.setSplitIterables(kafkaListener.splitIterables());
    }

    private void processKafkaListenerEndpointAfterRegistration(MethodKafkaListenerEndpoint<?, ?> endpoint, KafkaListener kafkaListener) {
        String converterBeanName;
        endpoint.setBeanFactory(this.beanFactory);
        String errorHandlerBeanName = this.resolveExpressionAsString(kafkaListener.errorHandler(), "errorHandler");
        if (StringUtils.hasText((String)errorHandlerBeanName)) {
            this.resolveErrorHandler(endpoint, kafkaListener);
        }
        if (StringUtils.hasText((String)(converterBeanName = this.resolveExpressionAsString(kafkaListener.contentTypeConverter(), "contentTypeConverter")))) {
            this.resolveContentTypeConverter(endpoint, kafkaListener);
        }
    }

    private void resolveErrorHandler(MethodKafkaListenerEndpoint<?, ?> endpoint, KafkaListener kafkaListener) {
        Object errorHandler = this.resolveExpression(kafkaListener.errorHandler());
        if (errorHandler instanceof KafkaListenerErrorHandler) {
            endpoint.setErrorHandler((KafkaListenerErrorHandler)errorHandler);
        } else {
            String errorHandlerBeanName = this.resolveExpressionAsString(kafkaListener.errorHandler(), "errorHandler");
            if (StringUtils.hasText((String)errorHandlerBeanName)) {
                endpoint.setErrorHandler((KafkaListenerErrorHandler)this.beanFactory.getBean(errorHandlerBeanName, KafkaListenerErrorHandler.class));
            }
        }
    }

    private void resolveContentTypeConverter(MethodKafkaListenerEndpoint<?, ?> endpoint, KafkaListener kafkaListener) {
        Object converter = this.resolveExpression(kafkaListener.contentTypeConverter());
        if (converter instanceof SmartMessageConverter) {
            endpoint.setMessagingConverter((SmartMessageConverter)converter);
        } else {
            String converterBeanName = this.resolveExpressionAsString(kafkaListener.contentTypeConverter(), "contentTypeConverter");
            if (StringUtils.hasText((String)converterBeanName)) {
                endpoint.setMessagingConverter((SmartMessageConverter)this.beanFactory.getBean(converterBeanName, SmartMessageConverter.class));
            }
        }
    }

    @Nullable
    private KafkaListenerContainerFactory<?> resolveContainerFactory(KafkaListener kafkaListener, Object factoryTarget, String beanName) {
        String containerFactory = kafkaListener.containerFactory();
        if (!StringUtils.hasText((String)containerFactory)) {
            return null;
        }
        KafkaListenerContainerFactory factory = null;
        Object resolved = this.resolveExpression(containerFactory);
        if (resolved instanceof KafkaListenerContainerFactory) {
            return (KafkaListenerContainerFactory)resolved;
        }
        String containerFactoryBeanName = this.resolveExpressionAsString(containerFactory, "containerFactory");
        if (StringUtils.hasText((String)containerFactoryBeanName)) {
            this.assertBeanFactory();
            try {
                factory = (KafkaListenerContainerFactory)this.beanFactory.getBean(containerFactoryBeanName, KafkaListenerContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException(this.noBeanFoundMessage(factoryTarget, beanName, containerFactoryBeanName, KafkaListenerContainerFactory.class), (Throwable)ex);
            }
        }
        return factory;
    }

    protected void assertBeanFactory() {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
    }

    protected String noBeanFoundMessage(Object target, String listenerBeanName, String requestedBeanName, Class<?> expectedClass) {
        return "Could not register Kafka listener endpoint on [" + target + "] for bean " + listenerBeanName + ", no '" + expectedClass.getSimpleName() + "' with id '" + requestedBeanName + "' was found in the application context";
    }

    private void resolveKafkaProperties(MethodKafkaListenerEndpoint<?, ?> endpoint, String[] propertyStrings) {
        if (propertyStrings.length > 0) {
            Properties properties = new Properties();
            for (String property : propertyStrings) {
                String value = this.resolveExpressionAsString(property, "property");
                if (value == null) continue;
                try {
                    properties.load(new StringReader(value));
                }
                catch (IOException e) {
                    this.logger.error((Throwable)e, () -> "Failed to load property " + property + ", continuing...");
                }
            }
            endpoint.setConsumerProperties(properties);
        }
    }

    private String getEndpointId(KafkaListener kafkaListener) {
        if (StringUtils.hasText((String)kafkaListener.id())) {
            return this.resolveExpressionAsString(kafkaListener.id(), "id");
        }
        return GENERATED_ID_PREFIX + this.counter.getAndIncrement();
    }

    private String getEndpointGroupId(KafkaListener kafkaListener, String id) {
        String groupId = null;
        if (StringUtils.hasText((String)kafkaListener.groupId())) {
            groupId = this.resolveExpressionAsString(kafkaListener.groupId(), "groupId");
        }
        if (groupId == null && kafkaListener.idIsGroup() && StringUtils.hasText((String)kafkaListener.id())) {
            groupId = id;
        }
        return groupId;
    }

    private TopicPartitionOffset[] resolveTopicPartitions(KafkaListener kafkaListener) {
        TopicPartition[] topicPartitions = kafkaListener.topicPartitions();
        ArrayList<TopicPartitionOffset> result = new ArrayList<TopicPartitionOffset>();
        if (topicPartitions.length > 0) {
            for (TopicPartition topicPartition : topicPartitions) {
                result.addAll(this.resolveTopicPartitionsList(topicPartition));
            }
        }
        return result.toArray(new TopicPartitionOffset[0]);
    }

    private String[] resolveTopics(KafkaListener kafkaListener) {
        String[] topics = kafkaListener.topics();
        ArrayList<String> result = new ArrayList<String>();
        if (topics.length > 0) {
            for (String topic1 : topics) {
                Object topic = this.resolveExpression(topic1);
                this.resolveAsString(topic, result);
            }
        }
        return result.toArray(new String[0]);
    }

    private Pattern resolvePattern(KafkaListener kafkaListener) {
        Pattern pattern = null;
        String text = kafkaListener.topicPattern();
        if (StringUtils.hasText((String)text)) {
            Object resolved = this.resolveExpression(text);
            if (resolved instanceof Pattern) {
                pattern = (Pattern)resolved;
            } else if (resolved instanceof String) {
                pattern = Pattern.compile((String)resolved);
            } else if (resolved != null) {
                throw new IllegalStateException("topicPattern must resolve to a Pattern or String, not " + resolved.getClass());
            }
        }
        return pattern;
    }

    private List<TopicPartitionOffset> resolveTopicPartitionsList(TopicPartition topicPartition) {
        Object topic = this.resolveExpression(topicPartition.topic());
        Assert.state((boolean)(topic instanceof String), () -> "topic in @TopicPartition must resolve to a String, not " + topic.getClass());
        Assert.state((boolean)StringUtils.hasText((String)((String)topic)), (String)"topic in @TopicPartition must not be empty");
        String[] partitions = topicPartition.partitions();
        PartitionOffset[] partitionOffsets = topicPartition.partitionOffsets();
        Assert.state((partitions.length > 0 || partitionOffsets.length > 0 ? 1 : 0) != 0, () -> "At least one 'partition' or 'partitionOffset' required in @TopicPartition for topic '" + topic + "'");
        ArrayList<TopicPartitionOffset> result = new ArrayList<TopicPartitionOffset>();
        for (String partition : partitions) {
            this.resolvePartitionAsInteger((String)topic, this.resolveExpression(partition), result, null, false, false);
        }
        if (partitionOffsets.length == 1 && partitionOffsets[0].partition().equals("*")) {
            result.forEach(tpo -> {
                tpo.setOffset(this.resolveInitialOffset(tpo.getTopic(), partitionOffsets[0]));
                tpo.setRelativeToCurrent(this.isRelative(tpo.getTopic(), partitionOffsets[0]));
            });
        } else {
            for (PartitionOffset partitionOffset : partitionOffsets) {
                Assert.isTrue((!partitionOffset.partition().equals("*") ? 1 : 0) != 0, () -> "Partition wildcard '*' is only allowed in a single @PartitionOffset in " + result);
                this.resolvePartitionAsInteger((String)topic, this.resolveExpression(partitionOffset.partition()), result, this.resolveInitialOffset(topic, partitionOffset), this.isRelative(topic, partitionOffset), true);
            }
        }
        Assert.isTrue((result.size() > 0 ? 1 : 0) != 0, () -> "At least one partition required for " + topic);
        return result;
    }

    private Long resolveInitialOffset(Object topic, PartitionOffset partitionOffset) {
        Long initialOffset;
        Object initialOffsetValue = this.resolveExpression(partitionOffset.initialOffset());
        if (initialOffsetValue instanceof String) {
            Assert.state((boolean)StringUtils.hasText((String)((String)initialOffsetValue)), () -> "'initialOffset' in @PartitionOffset for topic '" + topic + "' cannot be empty");
            initialOffset = Long.valueOf((String)initialOffsetValue);
        } else if (initialOffsetValue instanceof Long) {
            initialOffset = (Long)initialOffsetValue;
        } else {
            throw new IllegalArgumentException(String.format("@PartitionOffset for topic '%s' can't resolve '%s' as a Long or String, resolved to '%s'", topic, partitionOffset.initialOffset(), initialOffsetValue.getClass()));
        }
        return initialOffset;
    }

    private boolean isRelative(Object topic, PartitionOffset partitionOffset) {
        Boolean relativeToCurrent;
        Object relativeToCurrentValue = this.resolveExpression(partitionOffset.relativeToCurrent());
        if (relativeToCurrentValue instanceof String) {
            relativeToCurrent = Boolean.valueOf((String)relativeToCurrentValue);
        } else if (relativeToCurrentValue instanceof Boolean) {
            relativeToCurrent = (Boolean)relativeToCurrentValue;
        } else {
            throw new IllegalArgumentException(String.format("@PartitionOffset for topic '%s' can't resolve '%s' as a Boolean or String, resolved to '%s'", topic, partitionOffset.relativeToCurrent(), relativeToCurrentValue.getClass()));
        }
        return relativeToCurrent;
    }

    private void resolveAsString(Object resolvedValue, List<String> result) {
        if (resolvedValue instanceof String[]) {
            for (String object : (String[])resolvedValue) {
                this.resolveAsString(object, result);
            }
        } else if (resolvedValue instanceof String) {
            result.add((String)resolvedValue);
        } else if (resolvedValue instanceof Iterable) {
            for (Object object : (Iterable)resolvedValue) {
                this.resolveAsString(object, result);
            }
        } else {
            throw new IllegalArgumentException(String.format("@KafKaListener can't resolve '%s' as a String", resolvedValue));
        }
    }

    private void resolvePartitionAsInteger(String topic, Object resolvedValue, List<TopicPartitionOffset> result, @Nullable Long offset, boolean isRelative, boolean checkDups) {
        if (resolvedValue instanceof String[]) {
            for (String object : (String[])resolvedValue) {
                this.resolvePartitionAsInteger(topic, object, result, offset, isRelative, checkDups);
            }
        } else if (resolvedValue instanceof String) {
            Assert.state((boolean)StringUtils.hasText((String)((String)resolvedValue)), () -> "partition in @TopicPartition for topic '" + topic + "' cannot be empty");
            List<TopicPartitionOffset> collected = this.parsePartitions((String)resolvedValue).map(part -> new TopicPartitionOffset(topic, (int)part, offset, isRelative)).collect(Collectors.toList());
            if (checkDups) {
                collected.forEach(tpo -> Assert.state((!result.contains(tpo) ? 1 : 0) != 0, () -> String.format("@TopicPartition can't have the same partition configuration twice: [%s]", tpo)));
            }
            result.addAll(collected);
        } else if (resolvedValue instanceof Integer[]) {
            for (Integer partition : (Integer[])resolvedValue) {
                result.add(new TopicPartitionOffset(topic, partition));
            }
        } else if (resolvedValue instanceof Integer) {
            result.add(new TopicPartitionOffset(topic, (Integer)resolvedValue));
        } else if (resolvedValue instanceof Iterable) {
            for (Object object : (Iterable)resolvedValue) {
                this.resolvePartitionAsInteger(topic, object, result, offset, isRelative, checkDups);
            }
        } else {
            throw new IllegalArgumentException(String.format("@KafKaListener for topic '%s' can't resolve '%s' as an Integer or String", topic, resolvedValue));
        }
    }

    private String resolveExpressionAsString(String value, String attribute) {
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof String) {
            return (String)resolved;
        }
        if (resolved != null) {
            throw new IllegalStateException("The [" + attribute + "] must resolve to a String. Resolved to [" + resolved.getClass() + "] for [" + value + "]");
        }
        return null;
    }

    private Integer resolveExpressionAsInteger(String value, String attribute) {
        Object resolved = this.resolveExpression(value);
        Integer result = null;
        if (resolved instanceof String) {
            result = Integer.parseInt((String)resolved);
        } else if (resolved instanceof Number) {
            result = ((Number)resolved).intValue();
        } else if (resolved != null) {
            throw new IllegalStateException("The [" + attribute + "] must resolve to an Number or a String that can be parsed as an Integer. Resolved to [" + resolved.getClass() + "] for [" + value + "]");
        }
        return result;
    }

    private Boolean resolveExpressionAsBoolean(String value, String attribute) {
        Object resolved = this.resolveExpression(value);
        Boolean result = null;
        if (resolved instanceof Boolean) {
            result = (Boolean)resolved;
        } else if (resolved instanceof String) {
            result = Boolean.parseBoolean((String)resolved);
        } else if (resolved != null) {
            throw new IllegalStateException("The [" + attribute + "] must resolve to a Boolean or a String that can be parsed as a Boolean. Resolved to [" + resolved.getClass() + "] for [" + value + "]");
        }
        return result;
    }

    private Object resolveExpression(String value) {
        return this.resolver.evaluate(this.resolve(value), this.expressionContext);
    }

    private String resolve(String value) {
        if (this.beanFactory != null && this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).resolveEmbeddedValue(value);
        }
        return value;
    }

    private void addFormatters(FormatterRegistry registry) {
        for (Converter converter : this.getBeansOfType(Converter.class)) {
            registry.addConverter(converter);
        }
        for (GenericConverter genericConverter : this.getBeansOfType(GenericConverter.class)) {
            registry.addConverter(genericConverter);
        }
        for (Formatter formatter : this.getBeansOfType(Formatter.class)) {
            registry.addFormatter(formatter);
        }
    }

    private <T> Collection<T> getBeansOfType(Class<T> type) {
        if (this.beanFactory instanceof ListableBeanFactory) {
            return ((ListableBeanFactory)this.beanFactory).getBeansOfType(type).values();
        }
        return Collections.emptySet();
    }

    private Stream<Integer> parsePartitions(String partsString) {
        String[] partsStrings = partsString.split(",");
        if (partsStrings.length == 1 && !partsStrings[0].contains("-")) {
            return Stream.of(Integer.valueOf(Integer.parseInt(partsStrings[0].trim())));
        }
        ArrayList<Integer> parts = new ArrayList<Integer>();
        for (String part : partsStrings) {
            if (part.contains("-")) {
                String[] startEnd = part.split("-");
                Assert.state((startEnd.length == 2 ? 1 : 0) != 0, (String)("Only one hyphen allowed for a range of partitions: " + part));
                int start = Integer.parseInt(startEnd[0].trim());
                int end = Integer.parseInt(startEnd[1].trim());
                Assert.state((end >= start ? 1 : 0) != 0, (String)("Invalid range: " + part));
                for (int i = start; i <= end; ++i) {
                    parts.add(i);
                }
                continue;
            }
            this.parsePartitions(part).forEach(p -> parts.add((Integer)p));
        }
        return parts.stream().sorted().distinct();
    }

    public static interface AnnotationEnhancer
    extends BiFunction<Map<String, Object>, AnnotatedElement, Map<String, Object>> {
    }

    private static class ListenerScope
    implements Scope {
        private final Map<String, Object> listeners = new HashMap<String, Object>();

        ListenerScope() {
        }

        public void addListener(String key, Object bean) {
            this.listeners.put(key, bean);
        }

        public void removeListener(String key) {
            this.listeners.remove(key);
        }

        public Object get(String name, ObjectFactory<?> objectFactory) {
            return this.listeners.get(name);
        }

        public Object remove(String name) {
            return null;
        }

        public void registerDestructionCallback(String name, Runnable callback) {
        }

        public Object resolveContextualObject(String key) {
            return this.listeners.get(key);
        }

        public String getConversationId() {
            return null;
        }
    }

    private static class BytesToStringConverter
    implements Converter<byte[], String> {
        private final Charset charset;

        BytesToStringConverter(Charset charset) {
            this.charset = charset;
        }

        public String convert(byte[] source) {
            return new String(source, this.charset);
        }
    }

    private class KafkaHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        private final DefaultFormattingConversionService defaultFormattingConversionService = new DefaultFormattingConversionService();
        private MessageHandlerMethodFactory handlerMethodFactory;

        private KafkaHandlerMethodFactoryAdapter() {
        }

        public void setHandlerMethodFactory(MessageHandlerMethodFactory kafkaHandlerMethodFactory1) {
            this.handlerMethodFactory = kafkaHandlerMethodFactory1;
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            return this.getHandlerMethodFactory().createInvocableHandlerMethod(bean, method);
        }

        private MessageHandlerMethodFactory getHandlerMethodFactory() {
            if (this.handlerMethodFactory == null) {
                this.handlerMethodFactory = this.createDefaultMessageHandlerMethodFactory();
            }
            return this.handlerMethodFactory;
        }

        private MessageHandlerMethodFactory createDefaultMessageHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            Validator validator = KafkaListenerAnnotationBeanPostProcessor.this.registrar.getValidator();
            if (validator != null) {
                defaultFactory.setValidator(validator);
            }
            defaultFactory.setBeanFactory(KafkaListenerAnnotationBeanPostProcessor.this.beanFactory);
            this.defaultFormattingConversionService.addConverter((Converter)new BytesToStringConverter(KafkaListenerAnnotationBeanPostProcessor.this.charset));
            defaultFactory.setConversionService((ConversionService)this.defaultFormattingConversionService);
            GenericMessageConverter messageConverter = new GenericMessageConverter((ConversionService)this.defaultFormattingConversionService);
            defaultFactory.setMessageConverter((MessageConverter)messageConverter);
            ArrayList<HandlerMethodArgumentResolver> customArgumentsResolver = new ArrayList<HandlerMethodArgumentResolver>(KafkaListenerAnnotationBeanPostProcessor.this.registrar.getCustomMethodArgumentResolvers());
            customArgumentsResolver.add((HandlerMethodArgumentResolver)new KafkaNullAwarePayloadArgumentResolver((MessageConverter)messageConverter, validator));
            defaultFactory.setCustomArgumentResolvers(customArgumentsResolver);
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }
}

