/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import org.apache.kafka.common.header.Headers;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class SerializationUtils {
    private SerializationUtils() {
    }

    public static <P, T> BiFunction<P, Headers, T> propertyToMethodInvokingFunction(String methodProperty, Class<P> payloadType, ClassLoader classLoader) {
        Method method;
        Class clazz;
        int lastDotPosn = methodProperty.lastIndexOf(46);
        Assert.state((lastDotPosn > 1 ? 1 : 0) != 0, (String)"the method property needs to be a class name followed by the method name, separated by '.'");
        try {
            clazz = ClassUtils.forName((String)methodProperty.substring(0, lastDotPosn), (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalStateException(e);
        }
        String methodName = methodProperty.substring(lastDotPosn + 1);
        try {
            method = clazz.getDeclaredMethod(methodName, payloadType, Headers.class);
        }
        catch (NoSuchMethodException e) {
            try {
                method = clazz.getDeclaredMethod(methodName, payloadType);
            }
            catch (NoSuchMethodException e1) {
                IllegalStateException ise = new IllegalStateException("the parser method must take '(" + payloadType.getSimpleName() + ", Headers)' or '(" + payloadType.getSimpleName() + ")'", e1);
                ise.addSuppressed(e);
                throw ise;
            }
            catch (SecurityException e1) {
                IllegalStateException ise = new IllegalStateException(e1);
                ise.addSuppressed(e);
                throw ise;
            }
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        Method parseMethod = method;
        BiFunction<Object, Headers, Object> function = method.getParameters().length > 1 ? (str, headers) -> {
            try {
                return parseMethod.invoke(null, str, headers);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        } : (str, headers) -> {
            try {
                return parseMethod.invoke(null, str);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        };
        return function;
    }
}

