/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.streams;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.springframework.kafka.listener.ConsumerRecordRecoverer;
import org.springframework.util.ClassUtils;

public class RecoveringDeserializationExceptionHandler
implements DeserializationExceptionHandler {
    public static final String KSTREAM_DESERIALIZATION_RECOVERER = "spring.deserialization.recoverer";
    private static final Log LOGGER = LogFactory.getLog(RecoveringDeserializationExceptionHandler.class);
    private ConsumerRecordRecoverer recoverer;

    public RecoveringDeserializationExceptionHandler() {
    }

    public RecoveringDeserializationExceptionHandler(ConsumerRecordRecoverer recoverer) {
        this.recoverer = recoverer;
    }

    public DeserializationExceptionHandler.DeserializationHandlerResponse handle(ProcessorContext context, ConsumerRecord<byte[], byte[]> record, Exception exception) {
        if (this.recoverer == null) {
            return DeserializationExceptionHandler.DeserializationHandlerResponse.FAIL;
        }
        try {
            this.recoverer.accept(record, exception);
            return DeserializationExceptionHandler.DeserializationHandlerResponse.CONTINUE;
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"Recoverer threw an exception; recovery failed", (Throwable)e);
            return DeserializationExceptionHandler.DeserializationHandlerResponse.FAIL;
        }
    }

    public void configure(Map<String, ?> configs) {
        if (configs.containsKey(KSTREAM_DESERIALIZATION_RECOVERER)) {
            Object configValue = configs.get(KSTREAM_DESERIALIZATION_RECOVERER);
            if (configValue instanceof ConsumerRecordRecoverer) {
                this.recoverer = (ConsumerRecordRecoverer)configValue;
            } else if (configValue instanceof String) {
                this.fromString(configValue);
            } else if (configValue instanceof Class) {
                this.fromClass(configValue);
            } else {
                LOGGER.error((Object)"Unkown property type for spring.deserialization.recoverer; failed deserializations cannot be recovered");
            }
        }
    }

    private void fromString(Object configValue) throws LinkageError {
        try {
            Class clazz = ClassUtils.forName((String)((String)configValue), (ClassLoader)RecoveringDeserializationExceptionHandler.class.getClassLoader());
            Constructor constructor = clazz.getConstructor(new Class[0]);
            this.recoverer = (ConsumerRecordRecoverer)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to instantiate recoverer, failed deserializations cannot be recovered", (Throwable)e);
        }
    }

    private void fromClass(Object configValue) {
        try {
            Class clazz = (Class)configValue;
            Constructor constructor = clazz.getConstructor(new Class[0]);
            this.recoverer = (ConsumerRecordRecoverer)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to instantiate recoverer, failed deserializations cannot be recovered", (Throwable)e);
        }
    }
}

