/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.ContainerAwareBatchErrorHandler;
import org.springframework.kafka.listener.KafkaExceptionLogLevelAware;
import org.springframework.kafka.listener.ListenerUtils;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;

public class SeekToCurrentBatchErrorHandler
extends KafkaExceptionLogLevelAware
implements ContainerAwareBatchErrorHandler {
    private final ThreadLocal<BackOffExecution> backOffs = new ThreadLocal();
    private final ThreadLocal<Long> lastIntervals = new ThreadLocal();
    private BackOff backOff;

    public void setBackOff(BackOff backOff) {
        this.backOff = backOff;
    }

    @Override
    public void handle(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container) {
        data.partitions().stream().collect(Collectors.toMap(tp -> tp, tp -> ((ConsumerRecord)data.records(tp).get(0)).offset(), (u, v) -> (long)v, LinkedHashMap::new)).forEach((arg_0, arg_1) -> consumer.seek(arg_0, arg_1));
        if (this.backOff != null) {
            ListenerUtils.unrecoverableBackOff(this.backOff, this.backOffs, this.lastIntervals);
        }
        throw new KafkaException("Seek to current after exception", this.getLogLevel(), thrownException);
    }

    @Override
    public void clearThreadState() {
        this.backOffs.remove();
        this.lastIntervals.remove();
    }
}

