/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.event.ContainerStoppedEvent;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.BatchErrorHandler;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.DefaultAfterRollbackProcessor;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.GenericErrorHandler;
import org.springframework.kafka.listener.GenericMessageListener;
import org.springframework.kafka.listener.GenericMessageListenerContainer;
import org.springframework.kafka.support.TopicPartitionInitialOffset;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractMessageListenerContainer<K, V>
implements GenericMessageListenerContainer<K, V>,
BeanNameAware,
ApplicationEventPublisherAware {
    public static final int DEFAULT_PHASE = 2147483547;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ConsumerFactory<K, V> consumerFactory;
    private final ContainerProperties containerProperties;
    private final Object lifecycleMonitor = new Object();
    private String beanName;
    private ApplicationEventPublisher applicationEventPublisher;
    private GenericErrorHandler<?> errorHandler;
    private boolean autoStartup = true;
    private int phase = 2147483547;
    private AfterRollbackProcessor<? super K, ? super V> afterRollbackProcessor = new DefaultAfterRollbackProcessor<K, V>();
    private volatile boolean running = false;
    private volatile boolean paused;

    @Deprecated
    protected AbstractMessageListenerContainer(ContainerProperties containerProperties) {
        this(null, containerProperties);
    }

    protected AbstractMessageListenerContainer(ConsumerFactory<? super K, ? super V> consumerFactory, ContainerProperties containerProperties) {
        Assert.notNull((Object)containerProperties, (String)"'containerProperties' cannot be null");
        this.consumerFactory = consumerFactory;
        if (containerProperties.getTopics() != null) {
            this.containerProperties = new ContainerProperties(containerProperties.getTopics());
        } else if (containerProperties.getTopicPattern() != null) {
            this.containerProperties = new ContainerProperties(containerProperties.getTopicPattern());
        } else if (containerProperties.getTopicPartitions() != null) {
            this.containerProperties = new ContainerProperties(containerProperties.getTopicPartitions());
        } else {
            throw new IllegalStateException("topics, topicPattern, or topicPartitions must be provided");
        }
        BeanUtils.copyProperties((Object)containerProperties, (Object)this.containerProperties, (String[])new String[]{"topics", "topicPartitions", "topicPattern", "ackCount", "ackTime"});
        if (containerProperties.getAckCount() > 0) {
            this.containerProperties.setAckCount(containerProperties.getAckCount());
        }
        if (containerProperties.getAckTime() > 0L) {
            this.containerProperties.setAckTime(containerProperties.getAckTime());
        }
        if (this.containerProperties.getConsumerRebalanceListener() == null) {
            this.containerProperties.setConsumerRebalanceListener(this.createSimpleLoggingConsumerRebalanceListener());
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setGenericErrorHandler(GenericErrorHandler<?> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setBatchErrorHandler(BatchErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected GenericErrorHandler<?> getGenericErrorHandler() {
        return this.errorHandler;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    @Override
    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isPauseRequested() {
        return this.paused;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    protected AfterRollbackProcessor<? super K, ? super V> getAfterRollbackProcessor() {
        return this.afterRollbackProcessor;
    }

    public void setAfterRollbackProcessor(AfterRollbackProcessor<? super K, ? super V> afterRollbackProcessor) {
        Assert.notNull(afterRollbackProcessor, (String)"'afterRollbackProcessor' cannot be null");
        this.afterRollbackProcessor = afterRollbackProcessor;
    }

    @Override
    public ContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    @Override
    public void setupMessageListener(Object messageListener) {
        this.containerProperties.setMessageListener(messageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        this.checkGroupId();
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                Assert.isTrue((boolean)(this.containerProperties.getMessageListener() instanceof GenericMessageListener), () -> "A " + GenericMessageListener.class.getName() + " implementation must be provided");
                this.doStart();
            }
        }
    }

    protected void checkTopics() {
        if (this.containerProperties.isMissingTopicsFatal() && this.containerProperties.getTopicPattern() == null) {
            try (Consumer<K, V> consumer = this.consumerFactory.createConsumer(this.containerProperties.getGroupId(), this.containerProperties.getClientId(), null);){
                if (consumer != null) {
                    String[] topics = this.containerProperties.getTopics();
                    if (topics == null) {
                        topics = (String[])Arrays.stream(this.containerProperties.getTopicPartitions()).map(TopicPartitionInitialOffset::topic).toArray(String[]::new);
                    }
                    ArrayList<String> missing = new ArrayList<String>();
                    for (String topic : topics) {
                        if (consumer.partitionsFor(topic) != null) continue;
                        missing.add(topic);
                    }
                    if (missing.size() > 0) {
                        throw new IllegalStateException("Topic(s) " + ((Object)missing).toString() + " is/are not present and missingTopicsFatal is true");
                    }
                }
            }
        }
    }

    public void checkGroupId() {
        if (this.containerProperties.getTopicPartitions() == null) {
            boolean hasGroupIdConsumerConfig = true;
            if (this.consumerFactory != null) {
                Object groupIdConfig = this.consumerFactory.getConfigurationProperties().get("group.id");
                hasGroupIdConsumerConfig = groupIdConfig instanceof String && StringUtils.hasText((String)((String)groupIdConfig));
            }
            Assert.state((hasGroupIdConsumerConfig || StringUtils.hasText((String)this.containerProperties.getGroupId()) ? 1 : 0) != 0, (String)"No group.id found in consumer config, container properties, or @KafkaListener annotation; a group.id is required when group management is used.");
        }
    }

    protected abstract void doStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                CountDownLatch latch = new CountDownLatch(1);
                this.doStop(latch::countDown);
                try {
                    latch.await(this.containerProperties.getShutdownTimeout(), TimeUnit.MILLISECONDS);
                    this.publishContainerStoppedEvent();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                this.doStop(callback);
                this.publishContainerStoppedEvent();
            }
        }
    }

    protected abstract void doStop(Runnable var1);

    protected final ConsumerRebalanceListener createSimpleLoggingConsumerRebalanceListener() {
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                AbstractMessageListenerContainer.this.logger.info((Object)("partitions revoked: " + partitions));
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                AbstractMessageListenerContainer.this.logger.info((Object)("partitions assigned: " + partitions));
            }
        };
    }

    protected void publishContainerStoppedEvent() {
        ApplicationEventPublisher eventPublisher = this.getApplicationEventPublisher();
        if (eventPublisher != null) {
            eventPublisher.publishEvent((ApplicationEvent)new ContainerStoppedEvent(this, this.parentOrThis()));
        }
    }

    protected AbstractMessageListenerContainer<?, ?> parentOrThis() {
        return this;
    }
}

