/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.ContainerAwareErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;

public class SeekToCurrentErrorHandler
implements ContainerAwareErrorHandler {
    @Override
    public void handle(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        LinkedHashMap<TopicPartition, Long> offsets = new LinkedHashMap<TopicPartition, Long>();
        records.forEach(r -> offsets.computeIfAbsent(new TopicPartition(r.topic(), r.partition()), k -> r.offset()));
        offsets.forEach((arg_0, arg_1) -> consumer.seek(arg_0, arg_1));
        throw new KafkaException("Seek to current after exception", thrownException);
    }
}

