/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.FilterFactoryBean;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.xml.selector.XmlValidatingMessageSelector;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class XmlPayloadValidatingFilterParser
extends AbstractConsumerEndpointParser {
    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.genericBeanDefinition(FilterFactoryBean.class);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)filterBuilder, (Element)element, (String)"discard-channel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)filterBuilder, (Element)element, (String)"throw-exception-on-rejection");
        BeanDefinitionBuilder selectorBuilder = BeanDefinitionBuilder.genericBeanDefinition(XmlValidatingMessageSelector.class);
        String validator = element.getAttribute("xml-validator");
        String schemaLocation = element.getAttribute("schema-location");
        boolean validatorDefined = StringUtils.hasText((String)validator);
        boolean schemaLocationDefined = StringUtils.hasText((String)schemaLocation);
        if (!(validatorDefined ^ schemaLocationDefined)) {
            throw new BeanDefinitionStoreException("Exactly one of 'xml-validator' or 'schema-location' is allowed on the 'validating-filter' element");
        }
        if (schemaLocationDefined) {
            selectorBuilder.addConstructorArgValue((Object)schemaLocation);
            String schemaType = element.getAttribute("schema-type");
            selectorBuilder.addConstructorArgValue((Object)schemaType);
        } else {
            selectorBuilder.addConstructorArgReference(validator);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)selectorBuilder, (Element)element, (String)"throw-exception-on-rejection");
        filterBuilder.addPropertyValue("targetObject", (Object)selectorBuilder.getBeanDefinition());
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)filterBuilder, (Element)element, (String)"send-timeout");
        return filterBuilder;
    }
}

