/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.integration.config.xml.AbstractInboundGatewayParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class WebServiceInboundGatewayParser
extends AbstractInboundGatewayParser {
    protected String getBeanClassName(Element element) {
        String simpleClassName = StringUtils.hasText((String)element.getAttribute("marshaller")) ? "MarshallingWebServiceInboundGateway" : "SimpleWebServiceInboundGateway";
        return "org.springframework.integration.ws." + simpleClassName;
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return !attributeName.endsWith("marshaller") && super.isEligibleAttribute(attributeName);
    }

    protected void doPostProcess(BeanDefinitionBuilder builder, Element element) {
        String marshallerRef = element.getAttribute("marshaller");
        if (StringUtils.hasText((String)marshallerRef)) {
            builder.addConstructorArgReference(marshallerRef);
            String unmarshallerRef = element.getAttribute("unmarshaller");
            if (StringUtils.hasText((String)unmarshallerRef)) {
                builder.addConstructorArgReference(unmarshallerRef);
            }
        }
    }
}

