/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.webflux.dsl;

import java.net.URI;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.dsl.BaseHttpMessageHandlerSpec;
import org.springframework.integration.http.outbound.AbstractHttpRequestExecutingMessageHandler;
import org.springframework.integration.webflux.outbound.WebFluxRequestExecutingMessageHandler;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.client.WebClient;

public class WebFluxMessageHandlerSpec
extends BaseHttpMessageHandlerSpec<WebFluxMessageHandlerSpec, WebFluxRequestExecutingMessageHandler> {
    private final WebClient webClient;

    WebFluxMessageHandlerSpec(URI uri, WebClient webClient) {
        this((Expression)new ValueExpression((Object)uri), webClient);
    }

    WebFluxMessageHandlerSpec(String uri, WebClient webClient) {
        this((Expression)new LiteralExpression(uri), webClient);
    }

    WebFluxMessageHandlerSpec(Expression uriExpression, WebClient webClient) {
        super((AbstractHttpRequestExecutingMessageHandler)new WebFluxRequestExecutingMessageHandler(uriExpression, webClient));
        this.webClient = webClient;
    }

    public WebFluxMessageHandlerSpec replyPayloadToFlux(boolean replyPayloadToFlux) {
        ((WebFluxRequestExecutingMessageHandler)((Object)this.target)).setReplyPayloadToFlux(replyPayloadToFlux);
        return this;
    }

    public WebFluxMessageHandlerSpec bodyExtractor(BodyExtractor<?, ClientHttpResponse> bodyExtractor) {
        ((WebFluxRequestExecutingMessageHandler)((Object)this.target)).setBodyExtractor(bodyExtractor);
        return this;
    }

    protected boolean isClientSet() {
        return this.webClient != null;
    }

    protected WebFluxMessageHandlerSpec expectReply(boolean expectReply) {
        return (WebFluxMessageHandlerSpec)super.expectReply(expectReply);
    }
}

