/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog.inbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.syslog.DefaultMessageConverter;
import org.springframework.integration.syslog.MessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;

public abstract class SyslogReceivingChannelAdapterSupport
extends MessageProducerSupport {
    protected static final int DEFAULT_PORT = 514;
    private volatile int port = 514;
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private volatile MessageConverter converter = new DefaultMessageConverter();

    protected int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConverter(MessageConverter converter) {
        this.converter = converter;
    }

    protected void convertAndSend(Message<?> message) {
        try {
            this.sendMessage(this.converter.fromSyslog(message));
        }
        catch (Exception e) {
            throw new MessagingException(message, (Throwable)e);
        }
    }
}

