/*
 * Copyright 2002-2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.integration.syslog;

import org.springframework.integration.transformer.SyslogToMapTransformer;

/**
 * Headers in a {@code Map} generated by the @link {@link SyslogToMapTransformer} that
 * will be added to Spring Integration messages as headers, prefixed by {@link #PREFIX}.
 * @author Gary Russell
 * @since 3.0
 *
 */
public class SyslogHeaders {

	public static String PREFIX = "syslog_";

	public static final String FACILITY = PREFIX + SyslogToMapTransformer.FACILITY;

	public static final String SEVERITY = PREFIX + SyslogToMapTransformer.SEVERITY;

	public static final String TIMESTAMP = PREFIX + SyslogToMapTransformer.TIMESTAMP;

	public static final String HOST = PREFIX + SyslogToMapTransformer.HOST;

	public static final String TAG = PREFIX + SyslogToMapTransformer.TAG;

}
