/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog.inbound;

import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessagingException;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.ip.udp.UnicastReceivingChannelAdapter;
import org.springframework.integration.syslog.inbound.SyslogReceivingChannelAdapterSupport;

public class UdpSyslogReceivingChannelAdapter
extends SyslogReceivingChannelAdapterSupport {
    private volatile UnicastReceivingChannelAdapter udpAdapter;

    public void setUdpAdapter(UnicastReceivingChannelAdapter udpAdpter) {
        this.udpAdapter = udpAdpter;
    }

    protected void onInit() {
        if (this.udpAdapter == null) {
            this.udpAdapter = new UnicastReceivingChannelAdapter(this.getPort());
        }
        DirectChannel outputChannel = new DirectChannel();
        outputChannel.subscribe(new MessageHandler(){

            public void handleMessage(Message<?> message) throws MessagingException {
                UdpSyslogReceivingChannelAdapter.this.convertAndSend(message);
            }
        });
        this.udpAdapter.setOutputChannel((MessageChannel)outputChannel);
    }

    protected void doStart() {
        super.doStart();
        this.udpAdapter.start();
    }

    protected void doStop() {
        super.doStop();
        this.udpAdapter.stop();
    }
}

