/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.integration.Message;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.syslog.MessageConverter;
import org.springframework.integration.syslog.SyslogHeaders;
import org.springframework.integration.transformer.SyslogToMapTransformer;

public class DefaultMessageConverter
implements MessageConverter {
    private final SyslogToMapTransformer transformer = new SyslogToMapTransformer();
    public static final Set<String> SYSLOG_PAYLOAD_ENTRIES = new HashSet<String>(Arrays.asList("MESSAGE", "UNDECODED"));

    @Override
    public Message<?> fromSyslog(Message<?> message) throws Exception {
        Map map = (Map)this.transformer.doTransform(message);
        HashMap out = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (SYSLOG_PAYLOAD_ENTRIES.contains(key)) continue;
            out.put(SyslogHeaders.PREFIX + (String)entry.getKey(), entry.getValue());
        }
        return MessageBuilder.withPayload((Object)map).copyHeaders(out).build();
    }
}

