/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stomp.inbound;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.Lifecycle;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.stomp.StompSessionManager;
import org.springframework.integration.stomp.event.StompReceiptEvent;
import org.springframework.integration.stomp.support.StompHeaderMapper;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

@ManagedResource
@IntegrationManagedResource
public class StompInboundChannelAdapter
extends MessageProducerSupport
implements ApplicationEventPublisherAware {
    private final StompSessionHandler stompSessionHandler = new IntegrationInboundStompSessionHandler();
    private final Set<String> destinations = new LinkedHashSet<String>();
    private final StompSessionManager stompSessionManager;
    private final Map<String, StompSession.Subscription> subscriptions = new HashMap<String, StompSession.Subscription>();
    private final Lock destinationLock = new ReentrantLock();
    private ApplicationEventPublisher applicationEventPublisher;
    private Class<?> payloadType = String.class;
    private HeaderMapper<StompHeaders> headerMapper = new StompHeaderMapper();
    private volatile StompSession stompSession;

    public StompInboundChannelAdapter(StompSessionManager stompSessionManager, String ... destinations) {
        Assert.notNull((Object)stompSessionManager, (String)"'stompSessionManager' is required.");
        if (destinations != null) {
            for (String destination : destinations) {
                Assert.hasText((String)destination, (String)"'destinations' must not have empty strings.");
                this.destinations.add(destination);
            }
        }
        this.stompSessionManager = stompSessionManager;
    }

    public void setPayloadType(Class<?> payloadType) {
        Assert.notNull(payloadType, (String)"'payloadType' must not be null.");
        this.payloadType = payloadType;
    }

    public void setHeaderMapper(HeaderMapper<StompHeaders> headerMapper) {
        Assert.notNull(headerMapper, (String)"'headerMapper' must not be null.");
        this.headerMapper = headerMapper;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @ManagedAttribute
    public String[] getDestinations() {
        this.destinationLock.lock();
        try {
            String[] stringArray = this.destinations.toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.destinationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void addDestination(String ... destination) {
        Assert.notNull((Object)destination, (String)"'destination' cannot be null");
        this.destinationLock.lock();
        try {
            for (String d : destination) {
                if (!this.destinations.add(d)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Subscribe to destination '" + d + "'."));
                }
                this.subscribeDestination(d);
            }
        }
        finally {
            this.destinationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void removeDestination(String ... destination) {
        Assert.notNull((Object)destination, (String)"'destination' cannot be null");
        this.destinationLock.lock();
        try {
            for (String d : destination) {
                StompSession.Subscription subscription;
                if (!this.destinations.remove(d)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Removed '" + d + "' from subscriptions."));
                }
                if ((subscription = this.subscriptions.get(d)) != null) {
                    subscription.unsubscribe();
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("No subscription for destination '" + d + "'."));
            }
        }
        finally {
            this.destinationLock.unlock();
        }
    }

    public String getComponentType() {
        return "stomp:inbound-channel-adapter";
    }

    protected void doStart() {
        if (this.stompSessionManager instanceof Lifecycle) {
            ((Lifecycle)this.stompSessionManager).start();
        }
        this.stompSessionManager.connect(this.stompSessionHandler);
    }

    protected void doStop() {
        this.stompSessionManager.disconnect(this.stompSessionHandler);
        try {
            for (StompSession.Subscription subscription : this.subscriptions.values()) {
                subscription.unsubscribe();
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"The exception during unsubscribing.", (Throwable)e);
        }
        this.subscriptions.clear();
    }

    private void subscribeDestination(String destination) {
        if (this.stompSession != null) {
            StompSession.Subscription subscription = this.stompSession.subscribe(destination, new StompFrameHandler(){

                public Type getPayloadType(StompHeaders headers) {
                    return StompInboundChannelAdapter.this.payloadType;
                }

                public void handleFrame(StompHeaders headers, @Nullable Object body) {
                    Message message;
                    if (body == null) {
                        StompInboundChannelAdapter.this.logger.info((Object)"No body in STOMP frame: nothing to produce.");
                        return;
                    }
                    if (body instanceof Message) {
                        message = (Message)body;
                    } else {
                        Map headersToCopy = StompInboundChannelAdapter.this.headerMapper.toHeaders((Object)headers);
                        message = StompInboundChannelAdapter.this.getMessageBuilderFactory().withPayload(body).copyHeaders(headersToCopy).build();
                    }
                    StompInboundChannelAdapter.this.sendMessage(message);
                }
            });
            if (this.stompSessionManager.isAutoReceiptEnabled()) {
                ApplicationEventPublisher eventPublisher = this.applicationEventPublisher;
                if (eventPublisher != null) {
                    subscription.addReceiptTask(() -> {
                        StompReceiptEvent event = new StompReceiptEvent((Object)this, destination, subscription.getReceiptId(), StompCommand.SUBSCRIBE, false);
                        eventPublisher.publishEvent((ApplicationEvent)event);
                    });
                }
                subscription.addReceiptLostTask(() -> {
                    if (eventPublisher != null) {
                        StompReceiptEvent event = new StompReceiptEvent((Object)this, destination, subscription.getReceiptId(), StompCommand.SUBSCRIBE, true);
                        eventPublisher.publishEvent((ApplicationEvent)event);
                    } else {
                        this.logger.error((Object)("The receipt [" + subscription.getReceiptId() + "] is lost for [" + subscription.getSubscriptionId() + "] on destination [" + destination + "]"));
                    }
                });
            }
            this.subscriptions.put(destination, subscription);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("The StompInboundChannelAdapter [" + this.getComponentName() + "] ins't connected to StompSession. Check the state of [" + this.stompSessionManager + "]"));
        }
    }

    private class IntegrationInboundStompSessionHandler
    extends StompSessionHandlerAdapter {
        private IntegrationInboundStompSessionHandler() {
        }

        public void afterConnected(StompSession session, StompHeaders connectedHeaders) {
            StompInboundChannelAdapter.this.stompSession = session;
            for (String destination : StompInboundChannelAdapter.this.destinations) {
                StompInboundChannelAdapter.this.subscribeDestination(destination);
            }
        }

        public void handleException(StompSession session, @Nullable StompCommand command, StompHeaders headers, byte[] payload, Throwable exception) {
            MessageChannel errorChannel = StompInboundChannelAdapter.this.getErrorChannel();
            if (errorChannel != null) {
                Message failedMessage;
                Map headersToCopy = StompInboundChannelAdapter.this.headerMapper.toHeaders((Object)headers);
                if (command != null) {
                    StompHeaderAccessor headerAccessor = StompHeaderAccessor.create((StompCommand)command);
                    headerAccessor.copyHeaders(headersToCopy);
                    failedMessage = MessageBuilder.createMessage((Object)payload, (MessageHeaders)headerAccessor.getMessageHeaders());
                } else {
                    failedMessage = MessageBuilder.withPayload((Object)payload).copyHeaders(headersToCopy).build();
                }
                StompInboundChannelAdapter.this.getMessagingTemplate().send((Object)errorChannel, (Message)new ErrorMessage((Throwable)new MessageHandlingException(failedMessage, exception)));
            } else {
                StompInboundChannelAdapter.this.logger.error((Object)"STOMP Frame handling error.", exception);
            }
        }

        public void handleTransportError(StompSession session, Throwable exception) {
            StompInboundChannelAdapter.this.stompSession = null;
        }
    }
}

