/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rmi;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.core.MessageChannel;
import org.springframework.integration.gateway.RemotingInboundGatewaySupport;
import org.springframework.integration.gateway.RequestReplyExchanger;
import org.springframework.integration.history.NamedComponent;
import org.springframework.remoting.rmi.RmiServiceExporter;
import org.springframework.remoting.support.RemoteInvocationExecutor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RmiInboundGateway
extends RemotingInboundGatewaySupport
implements InitializingBean {
    public static final String SERVICE_NAME_PREFIX = "org.springframework.integration.rmiGateway.";
    private volatile String requestChannelName;
    private volatile String registryHost;
    private volatile int registryPort = 1099;
    private volatile RemoteInvocationExecutor remoteInvocationExecutor;
    private volatile RmiServiceExporter exporter;
    private final Object initializationMonitor = new Object();

    public void setRequestChannel(MessageChannel requestChannel) {
        Assert.notNull((Object)requestChannel, (String)"requestChannel must not be null");
        Assert.isTrue((requestChannel instanceof NamedComponent && StringUtils.hasText((String)((NamedComponent)requestChannel).getComponentName()) ? 1 : 0) != 0, (String)"RmiGateway's request channel must have a name.");
        this.requestChannelName = ((NamedComponent)requestChannel).getComponentName();
        super.setRequestChannel(requestChannel);
    }

    public void setRegistryHost(String registryHost) {
        this.registryHost = registryHost;
    }

    public void setRegistryPort(int registryPort) {
        this.registryPort = registryPort;
    }

    public void setRemoteInvocationExecutor(RemoteInvocationExecutor remoteInvocationExecutor) {
        this.remoteInvocationExecutor = remoteInvocationExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onInit() throws Exception {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.exporter == null) {
                RmiServiceExporter exporter = new RmiServiceExporter();
                if (this.registryHost != null) {
                    exporter.setRegistryHost(this.registryHost);
                }
                exporter.setRegistryPort(this.registryPort);
                if (this.remoteInvocationExecutor != null) {
                    exporter.setRemoteInvocationExecutor(this.remoteInvocationExecutor);
                }
                exporter.setService((Object)this);
                exporter.setServiceInterface(RequestReplyExchanger.class);
                exporter.setServiceName(SERVICE_NAME_PREFIX + this.requestChannelName);
                exporter.afterPropertiesSet();
                this.exporter = exporter;
            }
        }
        super.onInit();
    }
}

