/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.jms.ChannelPublishingJmsMessageListener;
import org.springframework.integration.jms.util.JmsAdapterUtils;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class JmsMessageDrivenEndpoint
extends MessageProducerSupport
implements DisposableBean,
OrderlyShutdownCapable {
    private final AbstractMessageListenerContainer listenerContainer;
    private final boolean externalContainer;
    private final ChannelPublishingJmsMessageListener listener;
    private volatile String sessionAcknowledgeMode;

    public JmsMessageDrivenEndpoint(AbstractMessageListenerContainer listenerContainer, ChannelPublishingJmsMessageListener listener) {
        this(listenerContainer, listener, true);
    }

    private JmsMessageDrivenEndpoint(AbstractMessageListenerContainer listenerContainer, ChannelPublishingJmsMessageListener listener, boolean externalContainer) {
        Assert.notNull((Object)listenerContainer, (String)"listener container must not be null");
        Assert.notNull((Object)listener, (String)"listener must not be null");
        if (this.logger.isWarnEnabled() && listenerContainer.getMessageListener() != null) {
            this.logger.warn((Object)"The provided listener container already has a MessageListener implementation, but it will be overridden by the provided ChannelPublishingJmsMessageListener.");
        }
        listenerContainer.setMessageListener((Object)listener);
        this.listener = listener;
        this.listenerContainer = listenerContainer;
        this.listenerContainer.setAutoStartup(false);
        this.setPhase(0x3FFFFFFF);
        this.externalContainer = externalContainer;
    }

    public void setSessionAcknowledgeMode(String sessionAcknowledgeMode) {
        this.sessionAcknowledgeMode = sessionAcknowledgeMode;
    }

    public void setOutputChannel(MessageChannel outputChannel) {
        super.setOutputChannel(outputChannel);
        this.listener.setRequestChannel(outputChannel);
    }

    public void setOutputChannelName(String outputChannelName) {
        super.setOutputChannelName(outputChannelName);
        this.listener.setRequestChannelName(outputChannelName);
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        super.setErrorChannel(errorChannel);
        this.listener.setErrorChannel(errorChannel);
    }

    public void setErrorChannelName(String errorChannelName) {
        super.setErrorChannelName(errorChannelName);
        this.listener.setErrorChannelName(errorChannelName);
    }

    public void setSendTimeout(long sendTimeout) {
        super.setSendTimeout(sendTimeout);
        this.listener.setRequestTimeout(sendTimeout);
    }

    public void setShouldTrack(boolean shouldTrack) {
        super.setShouldTrack(shouldTrack);
        this.listener.setShouldTrack(shouldTrack);
    }

    public ChannelPublishingJmsMessageListener getListener() {
        return this.listener;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.listener.setBeanFactory((BeanFactory)applicationContext);
    }

    public String getComponentType() {
        return "jms:message-driven-channel-adapter";
    }

    public void afterSingletonsInstantiated() {
    }

    protected void onInit() {
        Integer acknowledgeMode;
        String sessionAcknowledgeMode;
        super.onInit();
        this.listener.afterPropertiesSet();
        if (!this.listenerContainer.isActive()) {
            this.listenerContainer.afterPropertiesSet();
        }
        if ((sessionAcknowledgeMode = this.sessionAcknowledgeMode) == null && !this.externalContainer && DefaultMessageListenerContainer.class.isAssignableFrom(this.listenerContainer.getClass())) {
            sessionAcknowledgeMode = "transacted";
        }
        if ((acknowledgeMode = JmsAdapterUtils.parseAcknowledgeMode(sessionAcknowledgeMode)) != null) {
            if (0 == acknowledgeMode) {
                this.listenerContainer.setSessionTransacted(true);
            } else {
                this.listenerContainer.setSessionAcknowledgeMode(acknowledgeMode.intValue());
            }
        }
        this.listener.setComponentName(this.getComponentName());
    }

    protected void doStart() {
        this.listener.start();
        if (!this.listenerContainer.isRunning()) {
            this.listenerContainer.start();
        }
    }

    protected void doStop() {
        this.listenerContainer.stop();
        this.listener.stop();
    }

    public void destroy() throws Exception {
        if (this.isRunning()) {
            this.stop();
        }
        this.listenerContainer.destroy();
        super.destroy();
    }

    public int beforeShutdown() {
        this.stop();
        return 0;
    }

    public int afterShutdown() {
        return 0;
    }
}

