/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import java.util.ArrayDeque;
import java.util.List;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.ExecutorChannelInterceptorAware;
import org.springframework.integration.jms.AbstractJmsChannel;
import org.springframework.integration.jms.DynamicJmsTemplateProperties;
import org.springframework.integration.support.management.PollableChannelManagement;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ExecutorChannelInterceptor;

public class PollableJmsChannel
extends AbstractJmsChannel
implements PollableChannel,
PollableChannelManagement,
ExecutorChannelInterceptorAware {
    private volatile String messageSelector;
    private volatile int executorInterceptorsSize;

    public PollableJmsChannel(JmsTemplate jmsTemplate) {
        super(jmsTemplate);
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public int getReceiveCount() {
        return this.getMetrics().getReceiveCount();
    }

    public long getReceiveCountLong() {
        return this.getMetrics().getReceiveCountLong();
    }

    public int getReceiveErrorCount() {
        return this.getMetrics().getReceiveErrorCount();
    }

    public long getReceiveErrorCountLong() {
        return this.getMetrics().getReceiveErrorCountLong();
    }

    public Message<?> receive() {
        AbstractMessageChannel.ChannelInterceptorList interceptorList = this.getInterceptors();
        ArrayDeque interceptorStack = null;
        boolean counted = false;
        boolean countsEnabled = this.isCountsEnabled();
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("preReceive on channel '" + (Object)((Object)this) + "'"));
            }
            if (interceptorList.getInterceptors().size() > 0 && !interceptorList.preReceive((MessageChannel)this, interceptorStack = new ArrayDeque())) {
                return null;
            }
            Object object = this.messageSelector == null ? this.getJmsTemplate().receiveAndConvert() : this.getJmsTemplate().receiveSelectedAndConvert(this.messageSelector);
            if (object == null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("postReceive on channel '" + (Object)((Object)this) + "', message is null"));
                }
                return null;
            }
            if (countsEnabled) {
                this.getMetrics().afterReceive();
                counted = true;
            }
            Message message = null;
            message = object instanceof Message ? (Message)object : this.getMessageBuilderFactory().withPayload(object).build();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("postReceive on channel '" + (Object)((Object)this) + "', message: " + message));
            }
            if (interceptorStack != null) {
                message = interceptorList.postReceive(message, (MessageChannel)this);
                interceptorList.afterReceiveCompletion(message, (MessageChannel)this, null, interceptorStack);
            }
            return message;
        }
        catch (RuntimeException e) {
            if (countsEnabled && !counted) {
                this.getMetrics().afterError();
            }
            if (interceptorStack != null) {
                interceptorList.afterReceiveCompletion(null, (MessageChannel)this, (Exception)e, interceptorStack);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message<?> receive(long timeout) {
        try {
            DynamicJmsTemplateProperties.setReceiveTimeout(timeout);
            Message<?> message = this.receive();
            return message;
        }
        finally {
            DynamicJmsTemplateProperties.clearReceiveTimeout();
        }
    }

    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        super.setInterceptors(interceptors);
        for (ChannelInterceptor interceptor : interceptors) {
            if (!(interceptor instanceof ExecutorChannelInterceptor)) continue;
            ++this.executorInterceptorsSize;
        }
    }

    public void addInterceptor(ChannelInterceptor interceptor) {
        super.addInterceptor(interceptor);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            ++this.executorInterceptorsSize;
        }
    }

    public void addInterceptor(int index, ChannelInterceptor interceptor) {
        super.addInterceptor(index, interceptor);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            ++this.executorInterceptorsSize;
        }
    }

    public boolean removeInterceptor(ChannelInterceptor interceptor) {
        boolean removed = super.removeInterceptor(interceptor);
        if (removed && interceptor instanceof ExecutorChannelInterceptor) {
            --this.executorInterceptorsSize;
        }
        return removed;
    }

    public ChannelInterceptor removeInterceptor(int index) {
        ChannelInterceptor interceptor = super.removeInterceptor(index);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            --this.executorInterceptorsSize;
        }
        return interceptor;
    }

    public boolean hasExecutorInterceptors() {
        return this.executorInterceptorsSize > 0;
    }
}

