/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.lock;

import java.util.Date;
import java.util.UUID;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.integration.jdbc.lock.LockRepository;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Repository
@Transactional
public class DefaultLockRepository
implements LockRepository,
InitializingBean {
    public static final String DEFAULT_TABLE_PREFIX = "INT_";
    public static final int DEFAULT_TTL = 10000;
    private final String id;
    private final JdbcTemplate template;
    private int ttl = 10000;
    private String prefix = "INT_";
    private String region = "DEFAULT";
    private String deleteQuery = "DELETE FROM %sLOCK WHERE REGION=? AND LOCK_KEY=? AND CLIENT_ID=?";
    private String deleteExpiredQuery = "DELETE FROM %sLOCK WHERE REGION=? AND LOCK_KEY=? AND CREATED_DATE<?";
    private String deleteAllQuery = "DELETE FROM %sLOCK WHERE REGION=? AND CLIENT_ID=?";
    private String updateQuery = "UPDATE %sLOCK SET CREATED_DATE=? WHERE REGION=? AND LOCK_KEY=? AND CLIENT_ID=?";
    private String insertQuery = "INSERT INTO %sLOCK (REGION, LOCK_KEY, CLIENT_ID, CREATED_DATE) VALUES (?, ?, ?, ?)";
    private String countQuery = "SELECT COUNT(REGION) FROM %sLOCK WHERE REGION=? AND LOCK_KEY=? AND CLIENT_ID=? AND CREATED_DATE>=?";

    @Autowired
    public DefaultLockRepository(DataSource dataSource) {
        this(dataSource, UUID.randomUUID().toString());
    }

    public DefaultLockRepository(DataSource dataSource, String id) {
        Assert.hasText((String)id, (String)"id must not be null nor empty");
        this.template = new JdbcTemplate(dataSource);
        this.id = id;
    }

    public void setRegion(String region) {
        Assert.hasText((String)region, (String)"Region must not be null or empty.");
        this.region = region;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setTimeToLive(int timeToLive) {
        this.ttl = timeToLive;
    }

    public void afterPropertiesSet() {
        this.deleteQuery = String.format(this.deleteQuery, this.prefix);
        this.deleteExpiredQuery = String.format(this.deleteExpiredQuery, this.prefix);
        this.deleteAllQuery = String.format(this.deleteAllQuery, this.prefix);
        this.updateQuery = String.format(this.updateQuery, this.prefix);
        this.insertQuery = String.format(this.insertQuery, this.prefix);
        this.countQuery = String.format(this.countQuery, this.prefix);
    }

    @Override
    public void close() {
        this.template.update(this.deleteAllQuery, new Object[]{this.region, this.id});
    }

    @Override
    public void delete(String lock) {
        this.template.update(this.deleteQuery, new Object[]{this.region, lock, this.id});
    }

    @Override
    @Transactional(isolation=Isolation.SERIALIZABLE, timeout=1)
    public boolean acquire(String lock) {
        this.deleteExpired(lock);
        if (this.template.update(this.updateQuery, new Object[]{new Date(), this.region, lock, this.id}) > 0) {
            return true;
        }
        try {
            return this.template.update(this.insertQuery, new Object[]{this.region, lock, this.id, new Date()}) > 0;
        }
        catch (DuplicateKeyException e) {
            return false;
        }
    }

    @Override
    public boolean isAcquired(String lock) {
        this.deleteExpired(lock);
        return (Integer)this.template.queryForObject(this.countQuery, Integer.class, new Object[]{this.region, lock, this.id, new Date(System.currentTimeMillis() - (long)this.ttl)}) == 1;
    }

    private void deleteExpired(String lock) {
        this.template.update(this.deleteExpiredQuery, new Object[]{this.region, lock, new Date(System.currentTimeMillis() - (long)this.ttl)});
    }
}

