/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.jdbc.BeanPropertySqlParameterSourceFactory;
import org.springframework.integration.jdbc.ExpressionEvaluatingSqlParameterSourceFactory;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.jdbc.storedproc.ProcedureParameter;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcCall;
import org.springframework.jdbc.core.simple.SimpleJdbcCallOperations;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@ManagedResource
@IntegrationManagedResource
public class StoredProcExecutor
implements BeanFactoryAware,
InitializingBean {
    private static final boolean guavaPresent = ClassUtils.isPresent((String)"com.google.common.cache.LoadingCache", (ClassLoader)StoredProcExecutor.class.getClassLoader());
    private volatile EvaluationContext evaluationContext;
    private volatile BeanFactory beanFactory = null;
    private volatile int jdbcCallOperationsCacheSize = 10;
    private volatile GuavaCacheWrapper guavaCacheWrapper;
    private final Object jdbcCallOperationsMapMonitor = new Object();
    private volatile Map<String, SimpleJdbcCallOperations> jdbcCallOperationsMap;
    private volatile Expression storedProcedureNameExpression;
    private volatile boolean ignoreColumnMetaData = false;
    private volatile boolean skipUndeclaredResults = true;
    private volatile List<SqlParameter> sqlParameters = new ArrayList<SqlParameter>(0);
    private volatile SqlParameterSourceFactory sqlParameterSourceFactory = null;
    private volatile Boolean usePayloadAsParameterSource = null;
    private volatile List<ProcedureParameter> procedureParameters;
    private volatile boolean isFunction = false;
    private volatile boolean returnValueRequired = false;
    private volatile Map<String, RowMapper<?>> returningResultSetRowMappers = new HashMap(0);
    private final DataSource dataSource;

    public StoredProcExecutor(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"dataSource must not be null.");
        this.dataSource = dataSource;
    }

    public void afterPropertiesSet() {
        if (this.storedProcedureNameExpression == null) {
            throw new IllegalArgumentException("You must either provide a Stored Procedure Name or a Stored Procedure Name Expression.");
        }
        if (this.procedureParameters != null) {
            if (this.sqlParameterSourceFactory == null) {
                ExpressionEvaluatingSqlParameterSourceFactory expressionSourceFactory = new ExpressionEvaluatingSqlParameterSourceFactory();
                expressionSourceFactory.setBeanFactory(this.beanFactory);
                expressionSourceFactory.setStaticParameters(ProcedureParameter.convertStaticParameters(this.procedureParameters));
                expressionSourceFactory.setParameterExpressions(ProcedureParameter.convertExpressions(this.procedureParameters));
                this.sqlParameterSourceFactory = expressionSourceFactory;
            } else if (!(this.sqlParameterSourceFactory instanceof ExpressionEvaluatingSqlParameterSourceFactory)) {
                throw new IllegalStateException("You are providing 'ProcedureParameters'. Was expecting the the provided sqlParameterSourceFactory to be an instance of 'ExpressionEvaluatingSqlParameterSourceFactory', however the provided one is of type '" + this.sqlParameterSourceFactory.getClass().getName() + "'");
            }
            if (this.usePayloadAsParameterSource == null) {
                this.usePayloadAsParameterSource = false;
            }
        } else {
            if (this.sqlParameterSourceFactory == null) {
                this.sqlParameterSourceFactory = new BeanPropertySqlParameterSourceFactory();
            }
            if (this.usePayloadAsParameterSource == null) {
                this.usePayloadAsParameterSource = true;
            }
        }
        if (guavaPresent) {
            this.guavaCacheWrapper = new GuavaCacheWrapper(this, this.jdbcCallOperationsCacheSize);
        } else {
            this.jdbcCallOperationsMap = new LinkedHashMap<String, SimpleJdbcCallOperations>(this.jdbcCallOperationsCacheSize + 1, 0.75f, true){
                private static final long serialVersionUID = 3801124242820219131L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, SimpleJdbcCallOperations> eldest) {
                    return this.size() > StoredProcExecutor.this.jdbcCallOperationsCacheSize;
                }
            };
        }
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.beanFactory);
    }

    private SimpleJdbcCall createSimpleJdbcCall(String storedProcedureName) {
        SimpleJdbcCall simpleJdbcCall = new SimpleJdbcCall(this.dataSource);
        if (this.isFunction) {
            simpleJdbcCall.withFunctionName(storedProcedureName);
        } else {
            simpleJdbcCall.withProcedureName(storedProcedureName);
        }
        if (this.ignoreColumnMetaData) {
            simpleJdbcCall.withoutProcedureColumnMetaDataAccess();
        }
        simpleJdbcCall.declareParameters(this.sqlParameters.toArray(new SqlParameter[this.sqlParameters.size()]));
        if (!this.returningResultSetRowMappers.isEmpty()) {
            for (Map.Entry<String, RowMapper<?>> mapEntry : this.returningResultSetRowMappers.entrySet()) {
                simpleJdbcCall.returningResultSet(mapEntry.getKey(), mapEntry.getValue());
            }
        }
        if (this.returnValueRequired) {
            simpleJdbcCall.withReturnValue();
        }
        simpleJdbcCall.getJdbcTemplate().setSkipUndeclaredResults(this.skipUndeclaredResults);
        return simpleJdbcCall;
    }

    public Map<String, Object> executeStoredProcedure() {
        return this.executeStoredProcedureInternal(new Object(), this.evaluateExpression(null));
    }

    public Map<String, Object> executeStoredProcedure(Message<?> message) {
        Assert.notNull(message, (String)"The message parameter must not be null.");
        Assert.notNull((Object)this.usePayloadAsParameterSource, (String)"Property usePayloadAsParameterSource was Null. Did you call afterPropertiesSet()?");
        Object input = this.usePayloadAsParameterSource != false ? message.getPayload() : message;
        return this.executeStoredProcedureInternal(input, this.evaluateExpression(message));
    }

    private String evaluateExpression(Message<?> message) {
        String storedProcedureNameToUse = (String)this.storedProcedureNameExpression.getValue(this.evaluationContext, message, String.class);
        Assert.hasText((String)storedProcedureNameToUse, (String)String.format("Unable to resolve Stored Procedure/Function name for the provided Expression '%s'.", this.storedProcedureNameExpression.getExpressionString()));
        return storedProcedureNameToUse;
    }

    private Map<String, Object> executeStoredProcedureInternal(Object input, String storedProcedureName) {
        Assert.notNull((Object)this.sqlParameterSourceFactory, (String)"Property sqlParameterSourceFactory was Null. Did you call afterPropertiesSet()?");
        SimpleJdbcCallOperations localSimpleJdbcCall = this.obtainSimpleJdbcCall(storedProcedureName);
        SqlParameterSource storedProcedureParameterSource = this.sqlParameterSourceFactory.createParameterSource(input);
        return localSimpleJdbcCall.execute(storedProcedureParameterSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleJdbcCallOperations obtainSimpleJdbcCall(String storedProcedureName) {
        if (guavaPresent) {
            return (SimpleJdbcCallOperations)this.guavaCacheWrapper.jdbcCallOperationsCache.getUnchecked((Object)storedProcedureName);
        }
        SimpleJdbcCallOperations operations = this.jdbcCallOperationsMap.get(storedProcedureName);
        if (operations == null) {
            Object object = this.jdbcCallOperationsMapMonitor;
            synchronized (object) {
                operations = this.jdbcCallOperationsMap.get(storedProcedureName);
                if (operations == null) {
                    operations = this.createSimpleJdbcCall(storedProcedureName);
                    this.jdbcCallOperationsMap.put(storedProcedureName, operations);
                }
            }
        }
        return operations;
    }

    public void setIgnoreColumnMetaData(boolean ignoreColumnMetaData) {
        this.ignoreColumnMetaData = ignoreColumnMetaData;
    }

    public void setProcedureParameters(List<ProcedureParameter> procedureParameters) {
        Assert.notEmpty(procedureParameters, (String)"procedureParameters must not be null or empty.");
        for (ProcedureParameter procedureParameter : procedureParameters) {
            Assert.notNull((Object)procedureParameter, (String)"The provided list (procedureParameters) cannot contain null values.");
        }
        this.procedureParameters = procedureParameters;
    }

    public void setSqlParameters(List<SqlParameter> sqlParameters) {
        Assert.notEmpty(sqlParameters, (String)"sqlParameters must not be null or empty.");
        for (SqlParameter sqlParameter : sqlParameters) {
            Assert.notNull((Object)sqlParameter, (String)"The provided list (sqlParameters) cannot contain null values.");
        }
        this.sqlParameters = sqlParameters;
    }

    public void setSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        Assert.notNull((Object)sqlParameterSourceFactory, (String)"sqlParameterSourceFactory must not be null.");
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
    }

    @ManagedAttribute(defaultValue="Null if not Set.")
    public String getStoredProcedureName() {
        return this.storedProcedureNameExpression instanceof LiteralExpression ? (String)this.storedProcedureNameExpression.getValue(String.class) : null;
    }

    @ManagedAttribute(defaultValue="Null if not Set.")
    public String getStoredProcedureNameExpressionAsString() {
        return this.storedProcedureNameExpression != null ? this.storedProcedureNameExpression.getExpressionString() : null;
    }

    public void setStoredProcedureName(String storedProcedureName) {
        Assert.hasText((String)storedProcedureName, (String)"storedProcedureName must not be null and cannot be empty.");
        this.storedProcedureNameExpression = new LiteralExpression(storedProcedureName);
    }

    public void setStoredProcedureNameExpression(Expression storedProcedureNameExpression) {
        Assert.notNull((Object)storedProcedureNameExpression, (String)"storedProcedureNameExpression must not be null.");
        this.storedProcedureNameExpression = storedProcedureNameExpression;
    }

    public void setUsePayloadAsParameterSource(boolean usePayloadAsParameterSource) {
        this.usePayloadAsParameterSource = usePayloadAsParameterSource;
    }

    public void setIsFunction(boolean isFunction) {
        this.isFunction = isFunction;
    }

    public void setReturnValueRequired(boolean returnValueRequired) {
        this.returnValueRequired = returnValueRequired;
    }

    public void setSkipUndeclaredResults(boolean skipUndeclaredResults) {
        this.skipUndeclaredResults = skipUndeclaredResults;
    }

    public void setReturningResultSetRowMappers(Map<String, RowMapper<?>> returningResultSetRowMappers) {
        Assert.notNull(returningResultSetRowMappers, (String)"returningResultSetRowMappers must not be null.");
        for (RowMapper<?> rowMapper : returningResultSetRowMappers.values()) {
            Assert.notNull(rowMapper, (String)"The provided map cannot contain null values.");
        }
        this.returningResultSetRowMappers = returningResultSetRowMappers;
    }

    public Object getJdbcCallOperationsCacheStatistics() {
        if (!guavaPresent) {
            throw new UnsupportedOperationException("The Google Guava library isn't present in the classpath.");
        }
        return this.guavaCacheWrapper.jdbcCallOperationsCache.stats();
    }

    @ManagedMetric
    public Map<String, Object> getJdbcCallOperationsCacheStatisticsAsMap() {
        if (!guavaPresent) {
            throw new UnsupportedOperationException("The Google Guava library isn't present in the classpath.");
        }
        CacheStats cacheStats = (CacheStats)this.getJdbcCallOperationsCacheStatistics();
        HashMap<String, Number> cacheStatistics = new HashMap<String, Number>(11);
        cacheStatistics.put("averageLoadPenalty", cacheStats.averageLoadPenalty());
        cacheStatistics.put("evictionCount", cacheStats.evictionCount());
        cacheStatistics.put("hitCount", cacheStats.hitCount());
        cacheStatistics.put("hitRate", cacheStats.hitRate());
        cacheStatistics.put("loadCount", cacheStats.loadCount());
        cacheStatistics.put("loadExceptionCount", cacheStats.loadExceptionCount());
        cacheStatistics.put("loadExceptionRate", cacheStats.loadExceptionRate());
        cacheStatistics.put("loadSuccessCount", cacheStats.loadSuccessCount());
        cacheStatistics.put("missCount", cacheStats.missCount());
        cacheStatistics.put("missRate", cacheStats.missRate());
        cacheStatistics.put("totalLoadTime", cacheStats.totalLoadTime());
        return Collections.unmodifiableMap(cacheStatistics);
    }

    public void setJdbcCallOperationsCacheSize(int jdbcCallOperationsCacheSize) {
        Assert.isTrue((jdbcCallOperationsCacheSize >= 0 ? 1 : 0) != 0, (String)"jdbcCallOperationsCacheSize must not be negative.");
        this.jdbcCallOperationsCacheSize = jdbcCallOperationsCacheSize;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    private static class GuavaCacheWrapper {
        private final LoadingCache<String, SimpleJdbcCallOperations> jdbcCallOperationsCache;

        private GuavaCacheWrapper(final StoredProcExecutor executor, int size) {
            this.jdbcCallOperationsCache = CacheBuilder.newBuilder().maximumSize((long)size).recordStats().build((CacheLoader)new CacheLoader<String, SimpleJdbcCallOperations>(){

                public SimpleJdbcCallOperations load(String key) throws Exception {
                    return executor.createSimpleJdbcCall(key);
                }
            });
        }
    }
}

