/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.jdbc.BeanPropertySqlParameterSourceFactory;
import org.springframework.integration.jdbc.MessagePreparedStatementSetter;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class JdbcMessageHandler
extends AbstractMessageHandler {
    private final ResultSetExtractor<List<Map<String, Object>>> generatedKeysResultSetExtractor = new RowMapperResultSetExtractor((RowMapper)new ColumnMapRowMapper(), 1);
    private final NamedParameterJdbcOperations jdbcOperations;
    private final PreparedStatementCreator generatedKeysStatementCreator = new PreparedStatementCreator(){

        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            return con.prepareStatement(JdbcMessageHandler.this.updateSql, 1);
        }
    };
    private volatile String updateSql;
    private volatile SqlParameterSourceFactory sqlParameterSourceFactory;
    private volatile boolean keysGenerated;
    private MessagePreparedStatementSetter preparedStatementSetter;

    public JdbcMessageHandler(DataSource dataSource, String updateSql) {
        this.jdbcOperations = new NamedParameterJdbcTemplate(dataSource);
        this.updateSql = updateSql;
    }

    public JdbcMessageHandler(JdbcOperations jdbcOperations, String updateSql) {
        this.jdbcOperations = new NamedParameterJdbcTemplate(jdbcOperations);
        this.updateSql = updateSql;
    }

    public void setKeysGenerated(boolean keysGenerated) {
        this.keysGenerated = keysGenerated;
    }

    public void setUpdateSql(String updateSql) {
        this.updateSql = updateSql;
    }

    public void setSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
    }

    public void setPreparedStatementSetter(MessagePreparedStatementSetter preparedStatementSetter) {
        this.preparedStatementSetter = preparedStatementSetter;
    }

    public String getComponentType() {
        return "jdbc:outbound-channel-adapter";
    }

    protected void onInit() throws Exception {
        super.onInit();
        Assert.state((this.sqlParameterSourceFactory == null || this.preparedStatementSetter == null ? 1 : 0) != 0, (String)"'sqlParameterSourceFactory' and 'preparedStatementSetter' are mutually exclusive.");
        if (this.sqlParameterSourceFactory == null && this.preparedStatementSetter == null) {
            this.sqlParameterSourceFactory = new BeanPropertySqlParameterSourceFactory();
        }
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        List<? extends Map<String, Object>> keys = this.executeUpdateQuery(message, this.keysGenerated);
        if (!keys.isEmpty() && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generated keys: " + keys));
        }
    }

    protected List<? extends Map<String, Object>> executeUpdateQuery(final Message<?> message, boolean keysGenerated) {
        EmptySqlParameterSource updateParameterSource = EmptySqlParameterSource.INSTANCE;
        if (this.preparedStatementSetter == null && this.sqlParameterSourceFactory != null) {
            updateParameterSource = this.sqlParameterSourceFactory.createParameterSource(message);
        }
        if (keysGenerated) {
            if (this.preparedStatementSetter != null) {
                return (List)this.jdbcOperations.getJdbcOperations().execute(this.generatedKeysStatementCreator, (PreparedStatementCallback)new PreparedStatementCallback<List<Map<String, Object>>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public List<Map<String, Object>> doInPreparedStatement(PreparedStatement ps) throws SQLException {
                        JdbcMessageHandler.this.preparedStatementSetter.setValues(ps, message);
                        ps.executeUpdate();
                        ResultSet keys = ps.getGeneratedKeys();
                        if (keys != null) {
                            try {
                                List list = (List)JdbcMessageHandler.this.generatedKeysResultSetExtractor.extractData(keys);
                                return list;
                            }
                            finally {
                                JdbcUtils.closeResultSet((ResultSet)keys);
                            }
                        }
                        return new LinkedList<Map<String, Object>>();
                    }
                });
            }
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            this.jdbcOperations.update(this.updateSql, (SqlParameterSource)updateParameterSource, (KeyHolder)keyHolder);
            return keyHolder.getKeyList();
        }
        int updated = this.preparedStatementSetter != null ? this.jdbcOperations.getJdbcOperations().update(this.updateSql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                JdbcMessageHandler.this.preparedStatementSetter.setValues(ps, message);
            }
        }) : this.jdbcOperations.update(this.updateSql, (SqlParameterSource)updateParameterSource);
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap();
        map.put("UPDATED", (Object)updated);
        return Collections.singletonList(map);
    }
}

