/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.file;

import java.nio.charset.Charset;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.file.splitter.FileSplitter;
import org.springframework.util.Assert;

public class FileSplitterSpec
extends MessageHandlerSpec<FileSplitterSpec, FileSplitter> {
    private final FileSplitter fileSplitter;

    FileSplitterSpec() {
        this(true);
    }

    FileSplitterSpec(boolean iterator) {
        this(iterator, false);
    }

    FileSplitterSpec(boolean iterator, boolean markers) {
        this.fileSplitter = new FileSplitter(iterator, markers);
    }

    public FileSplitterSpec charset(String charset) {
        Assert.hasText((String)charset);
        return this.charset(Charset.forName(charset));
    }

    public FileSplitterSpec charset(Charset charset) {
        this.fileSplitter.setCharset(charset);
        return (FileSplitterSpec)this._this();
    }

    @Override
    protected FileSplitter doGet() {
        return this.fileSplitter;
    }
}

