/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.file;

import java.io.File;
import java.util.Comparator;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.FileLocker;
import org.springframework.integration.file.FileReadingMessageSource;
import org.springframework.integration.file.filters.AcceptOnceFileListFilter;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.IgnoreHiddenFileListFilter;
import org.springframework.integration.file.filters.RegexPatternFileListFilter;
import org.springframework.integration.file.filters.SimplePatternFileListFilter;
import org.springframework.integration.file.locking.NioFileLocker;
import org.springframework.util.Assert;

public class FileInboundChannelAdapterSpec
extends MessageSourceSpec<FileInboundChannelAdapterSpec, FileReadingMessageSource> {
    private CompositeFileListFilter<File> filter;
    private FileLocker locker;

    FileInboundChannelAdapterSpec() {
        this.target = new FileReadingMessageSource();
    }

    FileInboundChannelAdapterSpec(Comparator<File> receptionOrderComparator) {
        this.target = new FileReadingMessageSource(receptionOrderComparator);
    }

    FileInboundChannelAdapterSpec directory(File directory) {
        ((FileReadingMessageSource)this.target).setDirectory(directory);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec scanner(DirectoryScanner scanner) {
        ((FileReadingMessageSource)this.target).setScanner(scanner);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec autoCreateDirectory(boolean autoCreateDirectory) {
        ((FileReadingMessageSource)this.target).setAutoCreateDirectory(autoCreateDirectory);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec filter(FileListFilter<File> filter) {
        if (this.filter == null) {
            if (filter instanceof CompositeFileListFilter) {
                this.filter = (CompositeFileListFilter)filter;
            } else {
                this.filter = new CompositeFileListFilter();
                this.filter.addFilter(filter);
            }
            ((FileReadingMessageSource)this.target).setFilter(this.filter);
        } else {
            this.filter.addFilter(filter);
        }
        return (FileInboundChannelAdapterSpec)this._this();
    }

    @Deprecated
    public FileInboundChannelAdapterSpec filter(FileListFilter<File> filter, boolean preventDuplicates) {
        if (preventDuplicates) {
            this.filter((FileListFilter<File>)new AcceptOnceFileListFilter());
        }
        return this.filter(filter);
    }

    @Deprecated
    public FileInboundChannelAdapterSpec preventDuplicatesFilter(boolean preventDuplicates) {
        if (preventDuplicates) {
            return this.filter((FileListFilter<File>)new AcceptOnceFileListFilter());
        }
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec preventDuplicates() {
        return this.filter((FileListFilter<File>)new AcceptOnceFileListFilter());
    }

    public FileInboundChannelAdapterSpec ignoreHidden() {
        return this.filter((FileListFilter<File>)new IgnoreHiddenFileListFilter());
    }

    public FileInboundChannelAdapterSpec patternFilter(String pattern) {
        return this.filter((FileListFilter<File>)new SimplePatternFileListFilter(pattern));
    }

    @Deprecated
    public FileInboundChannelAdapterSpec patternFilter(String pattern, boolean preventDuplicates) {
        if (preventDuplicates) {
            this.preventDuplicates();
        }
        return this.patternFilter(pattern);
    }

    public FileInboundChannelAdapterSpec regexFilter(String regex) {
        return this.filter((FileListFilter<File>)new RegexPatternFileListFilter(regex));
    }

    @Deprecated
    public FileInboundChannelAdapterSpec regexFilter(String regex, boolean preventDuplicates) {
        if (preventDuplicates) {
            this.preventDuplicates();
        }
        return this.regexFilter(regex);
    }

    public FileInboundChannelAdapterSpec locker(FileLocker locker) {
        Assert.isNull((Object)this.locker, (String)("The 'locker' (" + this.locker + ") is already configured for the FileReadingMessageSource"));
        this.locker = locker;
        ((FileReadingMessageSource)this.target).setLocker(locker);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    public FileInboundChannelAdapterSpec nioLocker() {
        return this.locker((FileLocker)new NioFileLocker());
    }

    public FileInboundChannelAdapterSpec scanEachPoll(boolean scanEachPoll) {
        ((FileReadingMessageSource)this.target).setScanEachPoll(scanEachPoll);
        return (FileInboundChannelAdapterSpec)this._this();
    }

    @Override
    protected FileReadingMessageSource doGet() {
        throw new UnsupportedOperationException();
    }
}

