/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.file;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.FileWritingMessageHandler;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class FileWritingMessageHandlerSpec
extends MessageHandlerSpec<FileWritingMessageHandlerSpec, FileWritingMessageHandler>
implements ComponentsRegistration {
    private FileNameGenerator fileNameGenerator;
    private DefaultFileNameGenerator defaultFileNameGenerator;

    FileWritingMessageHandlerSpec(File destinationDirectory) {
        this.target = new FileWritingMessageHandler(destinationDirectory);
    }

    FileWritingMessageHandlerSpec(String directoryExpression) {
        this.target = new FileWritingMessageHandler(PARSER.parseExpression(directoryExpression));
    }

    <P> FileWritingMessageHandlerSpec(Function<Message<P>, ?> directoryFunction) {
        this.target = new FileWritingMessageHandler(new FunctionExpression<Message<P>>(directoryFunction));
    }

    FileWritingMessageHandlerSpec expectReply(boolean expectReply) {
        ((FileWritingMessageHandler)this.target).setExpectReply(expectReply);
        return (FileWritingMessageHandlerSpec)this._this();
    }

    public FileWritingMessageHandlerSpec autoCreateDirectory(boolean autoCreateDirectory) {
        ((FileWritingMessageHandler)this.target).setAutoCreateDirectory(autoCreateDirectory);
        return (FileWritingMessageHandlerSpec)this._this();
    }

    public FileWritingMessageHandlerSpec temporaryFileSuffix(String temporaryFileSuffix) {
        ((FileWritingMessageHandler)this.target).setTemporaryFileSuffix(temporaryFileSuffix);
        return (FileWritingMessageHandlerSpec)this._this();
    }

    public FileWritingMessageHandlerSpec fileExistsMode(FileExistsMode fileExistsMode) {
        ((FileWritingMessageHandler)this.target).setFileExistsMode(fileExistsMode);
        return (FileWritingMessageHandlerSpec)this._this();
    }

    public FileWritingMessageHandlerSpec fileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator;
        ((FileWritingMessageHandler)this.target).setFileNameGenerator(fileNameGenerator);
        return (FileWritingMessageHandlerSpec)this._this();
    }

    public FileWritingMessageHandlerSpec fileNameExpression(String fileNameExpression) {
        Assert.isNull((Object)this.fileNameGenerator, (String)"'fileNameGenerator' and 'fileNameGeneratorExpression' are mutually exclusive.");
        this.defaultFileNameGenerator = new DefaultFileNameGenerator();
        this.defaultFileNameGenerator.setExpression(fileNameExpression);
        return this.fileNameGenerator((FileNameGenerator)this.defaultFileNameGenerator);
    }

    public FileWritingMessageHandlerSpec deleteSourceFiles(boolean deleteSourceFiles) {
        ((FileWritingMessageHandler)this.target).setDeleteSourceFiles(deleteSourceFiles);
        return (FileWritingMessageHandlerSpec)this._this();
    }

    public FileWritingMessageHandlerSpec charset(String charset) {
        ((FileWritingMessageHandler)this.target).setCharset(charset);
        return (FileWritingMessageHandlerSpec)this._this();
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        if (this.defaultFileNameGenerator != null) {
            return Collections.singletonList(this.defaultFileNameGenerator);
        }
        return null;
    }

    @Override
    protected FileWritingMessageHandler doGet() {
        throw new UnsupportedOperationException();
    }
}

