/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.jms;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.jms.JmsTemplateSpec;
import org.springframework.integration.dsl.support.ComponentConfigurer;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.jms.JmsSendingMessageHandler;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.util.Assert;

public class JmsOutboundChannelAdapterSpec<S extends JmsOutboundChannelAdapterSpec<S>>
extends MessageHandlerSpec<S, JmsSendingMessageHandler> {
    protected final JmsTemplateSpec jmsTemplateSpec = new JmsTemplateSpec();

    JmsOutboundChannelAdapterSpec(JmsTemplate jmsTemplate) {
        this.target = new JmsSendingMessageHandler(jmsTemplate);
    }

    private JmsOutboundChannelAdapterSpec(ConnectionFactory connectionFactory) {
        this.target = new JmsSendingMessageHandler((JmsTemplate)((JmsTemplateSpec)this.jmsTemplateSpec.connectionFactory(connectionFactory)).get());
    }

    public S extractPayload(boolean extractPayload) {
        ((JmsSendingMessageHandler)this.target).setExtractPayload(extractPayload);
        return (S)((JmsOutboundChannelAdapterSpec)this._this());
    }

    public S headerMapper(JmsHeaderMapper headerMapper) {
        ((JmsSendingMessageHandler)this.target).setHeaderMapper(headerMapper);
        return (S)((JmsOutboundChannelAdapterSpec)this._this());
    }

    public S destination(Destination destination) {
        ((JmsSendingMessageHandler)this.target).setDestination(destination);
        return (S)((JmsOutboundChannelAdapterSpec)this._this());
    }

    public S destination(String destination) {
        ((JmsSendingMessageHandler)this.target).setDestinationName(destination);
        return (S)((JmsOutboundChannelAdapterSpec)this._this());
    }

    public S destinationExpression(String destination) {
        ((JmsSendingMessageHandler)this.target).setDestinationExpression(PARSER.parseExpression(destination));
        return (S)((JmsOutboundChannelAdapterSpec)this._this());
    }

    @Override
    protected JmsSendingMessageHandler doGet() {
        return null;
    }

    public static class JmsOutboundChannelSpecTemplateAware
    extends JmsOutboundChannelAdapterSpec<JmsOutboundChannelSpecTemplateAware> {
        JmsOutboundChannelSpecTemplateAware(ConnectionFactory connectionFactory) {
            super(connectionFactory);
        }

        public JmsOutboundChannelSpecTemplateAware configureJmsTemplate(ComponentConfigurer<JmsTemplateSpec> configurer) {
            Assert.notNull(configurer);
            configurer.configure(this.jmsTemplateSpec);
            return (JmsOutboundChannelSpecTemplateAware)this._this();
        }
    }
}

