/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.ip.CommonSocketOptions;

public abstract class AbstractInternetProtocolReceivingChannelAdapter
extends MessageProducerSupport
implements Runnable,
CommonSocketOptions {
    private final int port;
    private volatile int soTimeout = 0;
    private volatile int soReceiveBufferSize = -1;
    private volatile int receiveBufferSize = 2048;
    private volatile boolean active;
    private volatile boolean listening;
    private volatile String localAddress;
    private volatile Executor taskExecutor;
    private volatile int poolSize = 5;

    public AbstractInternetProtocolReceivingChannelAdapter(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public void setSoReceiveBufferSize(int soReceiveBufferSize) {
        this.soReceiveBufferSize = soReceiveBufferSize;
    }

    public int getSoReceiveBufferSize() {
        return this.soReceiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    protected void doStart() {
        if (!this.active) {
            this.active = true;
            String beanName = this.getComponentName();
            this.checkTaskExecutor((beanName == null ? "" : beanName + "-") + this.getComponentType());
            this.taskExecutor.execute(this);
        }
    }

    protected void checkTaskExecutor(final String threadName) {
        if (this.active && this.taskExecutor == null) {
            ExecutorService executor = Executors.newFixedThreadPool(this.poolSize, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runner) {
                    Thread thread = new Thread(runner);
                    thread.setName(threadName);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.taskExecutor = executor;
        }
    }

    protected void doStop() {
        this.active = false;
    }

    public boolean isListening() {
        return this.listening;
    }

    public void setListening(boolean listening) {
        this.listening = listening;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public Executor getTaskExecutor() {
        return this.taskExecutor;
    }

    public boolean isActive() {
        return this.active;
    }
}

