/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.Lifecycle;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.endpoint.AbstractFetchLimitingMessageSource;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.ResettableFileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.support.FileUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractRemoteFileStreamingMessageSource<F>
extends AbstractFetchLimitingMessageSource<InputStream>
implements Lifecycle {
    private final RemoteFileTemplate<F> remoteFileTemplate;
    private final BlockingQueue<AbstractFileInfo<F>> toBeReceived = new LinkedBlockingQueue<AbstractFileInfo<F>>();
    private final Comparator<F> comparator;
    private final AtomicBoolean running = new AtomicBoolean();
    private boolean fileInfoJson = true;
    private Expression remoteDirectoryExpression;
    private String remoteFileSeparator = "/";
    private FileListFilter<F> filter;

    protected AbstractRemoteFileStreamingMessageSource(RemoteFileTemplate<F> template, @Nullable Comparator<F> comparator) {
        Assert.notNull(template, (String)"'template' must not be null");
        this.remoteFileTemplate = template;
        this.comparator = comparator;
    }

    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectoryExpression = new LiteralExpression(remoteDirectory);
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        Assert.notNull((Object)remoteDirectoryExpression, (String)"'remoteDirectoryExpression' must not be null");
        this.remoteDirectoryExpression = remoteDirectoryExpression;
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        Assert.notNull((Object)remoteFileSeparator, (String)"'remoteFileSeparator' must not be null");
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public void setFilter(FileListFilter<F> filter) {
        this.doSetFilter(filter);
    }

    protected final void doSetFilter(FileListFilter<F> filterToSet) {
        this.filter = filterToSet;
    }

    public void setFileInfoJson(boolean fileInfoJson) {
        this.fileInfoJson = fileInfoJson;
    }

    protected RemoteFileTemplate<F> getRemoteFileTemplate() {
        return this.remoteFileTemplate;
    }

    public final void onInit() {
        Assert.state((this.remoteDirectoryExpression != null ? 1 : 0) != 0, (String)"'remoteDirectoryExpression' must not be null");
        this.doInit();
    }

    protected void doInit() {
    }

    public void start() {
        this.running.set(true);
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            AbstractFileInfo file = (AbstractFileInfo)this.toBeReceived.poll();
            while (file != null) {
                this.resetFilterIfNecessary(file);
                file = (AbstractFileInfo)this.toBeReceived.poll();
            }
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    protected Object doReceive() {
        Assert.state((boolean)this.running.get(), () -> this.getComponentName() + " is not running");
        AbstractFileInfo<F> file = this.poll();
        if (file != null) {
            try {
                String remotePath = this.remotePath(file);
                Session<F> session = this.remoteFileTemplate.getSession();
                try {
                    return this.getMessageBuilderFactory().withPayload((Object)session.readRaw(remotePath)).setHeader("closeableResource", session).setHeader("file_remoteDirectory", (Object)file.getRemoteDirectory()).setHeader("file_remoteFile", (Object)file.getFilename()).setHeader("file_remoteFileInfo", this.fileInfoJson ? file.toJson() : file);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("IOException when retrieving " + remotePath, e);
                }
            }
            catch (RuntimeException e) {
                this.resetFilterIfNecessary(file);
                throw e;
            }
        }
        return null;
    }

    protected Object doReceive(int maxFetchSize) {
        return this.doReceive();
    }

    private void resetFilterIfNecessary(AbstractFileInfo<F> file) {
        if (this.filter instanceof ResettableFileListFilter) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Removing the remote file '" + file + "' from the filter for a subsequent transfer attempt"));
            }
            ((ResettableFileListFilter)this.filter).remove(file.getFileInfo());
        }
    }

    protected AbstractFileInfo<F> poll() {
        if (this.toBeReceived.size() == 0) {
            this.listFiles();
        }
        return (AbstractFileInfo)this.toBeReceived.poll();
    }

    protected String remotePath(AbstractFileInfo<F> file) {
        return file.getRemoteDirectory().endsWith(this.remoteFileSeparator) ? file.getRemoteDirectory() + file.getFilename() : file.getRemoteDirectory() + this.remoteFileSeparator + file.getFilename();
    }

    private void listFiles() {
        String remoteDirectory = (String)this.remoteDirectoryExpression.getValue((EvaluationContext)this.getEvaluationContext(), String.class);
        Object[] files = this.remoteFileTemplate.list(remoteDirectory);
        if (!ObjectUtils.isEmpty((Object[])files)) {
            files = FileUtils.purgeUnwantedElements(files, f -> f == null || this.isDirectory(f), this.comparator);
        }
        if (!ObjectUtils.isEmpty((Object[])files)) {
            List<Object> filteredFiles;
            int maxFetchSize = this.getMaxFetchSize();
            List<Object> list = filteredFiles = this.filter == null ? Arrays.asList(files) : this.filter.filterFiles(files);
            if (maxFetchSize > 0 && filteredFiles.size() > maxFetchSize) {
                this.rollbackFromFileToListEnd(filteredFiles, filteredFiles.get(maxFetchSize));
                ArrayList<Object> newList = new ArrayList<Object>(maxFetchSize);
                for (int i = 0; i < maxFetchSize; ++i) {
                    newList.add(filteredFiles.get(i));
                }
                filteredFiles = newList;
            }
            List<AbstractFileInfo<Object>> fileInfoList = this.asFileInfoList(filteredFiles);
            fileInfoList.forEach(fi -> fi.setRemoteDirectory(remoteDirectory));
            this.toBeReceived.addAll(fileInfoList);
        }
    }

    protected void rollbackFromFileToListEnd(List<F> filteredFiles, F file) {
        if (this.filter instanceof ReversibleFileListFilter) {
            ((ReversibleFileListFilter)this.filter).rollback(file, filteredFiles);
        }
    }

    protected abstract List<AbstractFileInfo<F>> asFileInfoList(Collection<F> var1);

    protected abstract boolean isDirectory(F var1);
}

