/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.filters.AbstractPersistentAcceptOnceFileListFilter;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.ExpressionFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.RemoteFileOperations;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public final class FileParserUtils {
    private FileParserUtils() {
    }

    public static BeanDefinition parseRemoteFileTemplate(Element element, ParserContext parserContext, boolean atLeastOneRemoteDirectoryAttributeRequired, Class<? extends RemoteFileOperations<?>> templateClass) {
        BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(templateClass);
        templateBuilder.addConstructorArgReference(element.getAttribute("session-factory"));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)templateBuilder, (Element)element, (String)"temporary-file-suffix");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)templateBuilder, (Element)element, (String)"use-temporary-file-name");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)templateBuilder, (Element)element, (String)"auto-create-directory");
        BeanDefinition expressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"remote-directory", (String)"remote-directory-expression", (ParserContext)parserContext, (Element)element, (boolean)atLeastOneRemoteDirectoryAttributeRequired);
        if (expressionDef != null) {
            templateBuilder.addPropertyValue("remoteDirectoryExpression", (Object)expressionDef);
        }
        if ((expressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"temporary-remote-directory", (String)"temporary-remote-directory-expression", (ParserContext)parserContext, (Element)element, (boolean)false)) != null) {
            templateBuilder.addPropertyValue("temporaryRemoteDirectoryExpression", (Object)expressionDef);
        }
        String remoteFileNameGenerator = element.getAttribute("remote-filename-generator");
        String remoteFileNameGeneratorExpression = element.getAttribute("remote-filename-generator-expression");
        boolean hasRemoteFileNameGenerator = StringUtils.hasText((String)remoteFileNameGenerator);
        boolean hasRemoteFileNameGeneratorExpression = StringUtils.hasText((String)remoteFileNameGeneratorExpression);
        if (hasRemoteFileNameGenerator || hasRemoteFileNameGeneratorExpression) {
            if (hasRemoteFileNameGenerator && hasRemoteFileNameGeneratorExpression) {
                parserContext.getReaderContext().error("at most one of 'remote-filename-generator-expression' or 'remote-filename-generator' is allowed on a remote file outbound adapter", (Object)element);
            }
            if (hasRemoteFileNameGenerator) {
                templateBuilder.addPropertyReference("fileNameGenerator", remoteFileNameGenerator);
            } else {
                BeanDefinitionBuilder fileNameGeneratorBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultFileNameGenerator.class);
                fileNameGeneratorBuilder.addPropertyValue("expression", (Object)remoteFileNameGeneratorExpression);
                templateBuilder.addPropertyValue("fileNameGenerator", (Object)fileNameGeneratorBuilder.getBeanDefinition());
            }
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)templateBuilder, (Element)element, (String)"charset");
        templateBuilder.addPropertyValue("remoteFileSeparator", (Object)element.getAttribute("remote-file-separator"));
        return templateBuilder.getBeanDefinition();
    }

    static void configureFilter(BeanDefinitionBuilder synchronizerBuilder, Element element, ParserContext parserContext, Class<? extends FileListFilter<?>> patternClass, Class<? extends FileListFilter<?>> regexClass, Class<? extends AbstractPersistentAcceptOnceFileListFilter<?>> persistentAcceptOnceFileListFilterClass) {
        String filter = element.getAttribute("filter");
        String filterExpression = element.getAttribute("filter-expression");
        String fileNamePattern = element.getAttribute("filename-pattern");
        String fileNameRegex = element.getAttribute("filename-regex");
        boolean hasFilter = StringUtils.hasText((String)filter);
        boolean hasFilterExpression = StringUtils.hasText((String)filterExpression);
        boolean hasFileNamePattern = StringUtils.hasText((String)fileNamePattern);
        boolean hasFileNameRegex = StringUtils.hasText((String)fileNameRegex);
        if (hasFilter || hasFilterExpression || hasFileNamePattern || hasFileNameRegex) {
            int count = 0;
            if (hasFilter) {
                ++count;
            }
            if (hasFileNamePattern) {
                ++count;
            }
            if (hasFileNameRegex) {
                ++count;
            }
            if (hasFilterExpression) {
                ++count;
            }
            if (count != 1) {
                parserContext.getReaderContext().error("at most one of 'filename-pattern', 'filename-regex', 'filter' or 'filter-expression' is allowed on remote file inbound adapter", (Object)element);
            }
            if (hasFilter) {
                synchronizerBuilder.addPropertyReference("filter", filter);
            } else if (hasFilterExpression) {
                AbstractBeanDefinition expressionFilterBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFileListFilter.class).addConstructorArgValue((Object)filterExpression).getBeanDefinition();
                synchronizerBuilder.addPropertyValue("filter", (Object)expressionFilterBeanDefinition);
            } else if (hasFileNamePattern) {
                AbstractBeanDefinition patternFilter = BeanDefinitionBuilder.genericBeanDefinition(patternClass).addConstructorArgValue((Object)fileNamePattern).getBeanDefinition();
                FileParserUtils.composeFilters(synchronizerBuilder, persistentAcceptOnceFileListFilterClass, (BeanDefinition)patternFilter);
            } else {
                AbstractBeanDefinition regexFilter = BeanDefinitionBuilder.genericBeanDefinition(regexClass).addConstructorArgValue((Object)fileNameRegex).getBeanDefinition();
                FileParserUtils.composeFilters(synchronizerBuilder, persistentAcceptOnceFileListFilterClass, (BeanDefinition)regexFilter);
            }
        }
    }

    private static void composeFilters(BeanDefinitionBuilder synchronizerBuilder, Class<? extends AbstractPersistentAcceptOnceFileListFilter<?>> persistentAcceptOnceFileListFilterClass, BeanDefinition filter) {
        AbstractBeanDefinition persistentFilter = BeanDefinitionBuilder.genericBeanDefinition(persistentAcceptOnceFileListFilterClass).addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(SimpleMetadataStore.class).getBeanDefinition()).addConstructorArgValue((Object)"remoteFileMessageSource").getBeanDefinition();
        ManagedList filters = new ManagedList();
        filters.add((Object)filter);
        filters.add((Object)persistentFilter);
        AbstractBeanDefinition compositeFilterDefinition = BeanDefinitionBuilder.genericBeanDefinition(CompositeFileListFilter.class).addConstructorArgValue((Object)filters).getBeanDefinition();
        synchronizerBuilder.addPropertyValue("filter", (Object)compositeFilterDefinition);
    }
}

