/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.tail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import org.springframework.integration.file.tail.FileTailingMessageProducerSupport;
import org.springframework.messaging.MessagingException;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;

public class OSDelegatingFileTailingMessageProducer
extends FileTailingMessageProducerSupport
implements SchedulingAwareRunnable {
    private volatile Process process;
    private volatile String options = "-F -n 0";
    private volatile String command = "ADAPTER_NOT_INITIALIZED";
    private volatile BufferedReader reader;
    private volatile TaskScheduler scheduler;

    public void setOptions(String options) {
        this.options = options == null ? "" : options;
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public String getComponentType() {
        return super.getComponentType() + " (native)";
    }

    public boolean isLongLived() {
        return true;
    }

    protected void onInit() {
        Assert.notNull((Object)this.getFile(), (String)"File cannot be null");
        super.onInit();
    }

    protected void doStart() {
        super.doStart();
        this.destroyProcess();
        this.command = "tail " + this.options + " " + this.getFile().getAbsolutePath();
        this.getTaskExecutor().execute(new Runnable(){

            @Override
            public void run() {
                OSDelegatingFileTailingMessageProducer.this.runExec();
            }
        });
    }

    protected void doStop() {
        super.doStop();
        this.destroyProcess();
    }

    private void destroyProcess() {
        Process process = this.process;
        if (process != null) {
            process.destroy();
            this.process = null;
        }
    }

    private void runExec() {
        this.destroyProcess();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Starting tail process");
        }
        try {
            Process process = Runtime.getRuntime().exec(this.command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            this.process = process;
            this.startProcessMonitor();
            this.startStatusReader();
            this.reader = reader;
            this.getTaskExecutor().execute((Runnable)((Object)this));
        }
        catch (IOException e) {
            throw new MessagingException("Failed to exec tail command: '" + this.command + "'", (Throwable)e);
        }
    }

    private TaskScheduler getRequiredTaskScheduler() {
        if (this.scheduler == null) {
            TaskScheduler taskScheduler = super.getTaskScheduler();
            if (taskScheduler == null) {
                ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
                scheduler.initialize();
                taskScheduler = scheduler;
            }
            this.scheduler = taskScheduler;
        }
        return this.scheduler;
    }

    private void startProcessMonitor() {
        this.getTaskExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Process process = OSDelegatingFileTailingMessageProducer.this.process;
                if (process == null) {
                    if (OSDelegatingFileTailingMessageProducer.this.logger.isDebugEnabled()) {
                        OSDelegatingFileTailingMessageProducer.this.logger.debug((Object)"Process destroyed before starting process monitor");
                    }
                    return;
                }
                int result = Integer.MIN_VALUE;
                try {
                    if (OSDelegatingFileTailingMessageProducer.this.logger.isDebugEnabled()) {
                        OSDelegatingFileTailingMessageProducer.this.logger.debug((Object)("Monitoring process " + process));
                    }
                    result = process.waitFor();
                    if (OSDelegatingFileTailingMessageProducer.this.logger.isInfoEnabled()) {
                        OSDelegatingFileTailingMessageProducer.this.logger.info((Object)("tail process terminated with value " + result));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    OSDelegatingFileTailingMessageProducer.this.logger.error((Object)"Interrupted - stopping adapter", (Throwable)e);
                    OSDelegatingFileTailingMessageProducer.this.stop();
                }
                finally {
                    OSDelegatingFileTailingMessageProducer.this.destroyProcess();
                }
                if (OSDelegatingFileTailingMessageProducer.this.isRunning()) {
                    if (OSDelegatingFileTailingMessageProducer.this.logger.isInfoEnabled()) {
                        OSDelegatingFileTailingMessageProducer.this.logger.info((Object)("Restarting tail process in " + OSDelegatingFileTailingMessageProducer.this.getMissingFileDelay() + " milliseconds"));
                    }
                    OSDelegatingFileTailingMessageProducer.this.getRequiredTaskScheduler().schedule(new Runnable(){

                        @Override
                        public void run() {
                            OSDelegatingFileTailingMessageProducer.this.runExec();
                        }
                    }, new Date(System.currentTimeMillis() + OSDelegatingFileTailingMessageProducer.this.getMissingFileDelay()));
                }
            }
        });
    }

    private void startStatusReader() {
        Process process = this.process;
        if (process == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Process destroyed before starting stderr reader");
            }
            return;
        }
        final BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        this.getTaskExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (OSDelegatingFileTailingMessageProducer.this.logger.isDebugEnabled()) {
                    OSDelegatingFileTailingMessageProducer.this.logger.debug((Object)"Reading stderr");
                }
                try {
                    String statusMessage;
                    while ((statusMessage = errorReader.readLine()) != null) {
                        OSDelegatingFileTailingMessageProducer.this.publish(statusMessage);
                        if (!OSDelegatingFileTailingMessageProducer.this.logger.isTraceEnabled()) continue;
                        OSDelegatingFileTailingMessageProducer.this.logger.trace((Object)statusMessage);
                    }
                }
                catch (IOException e) {
                    if (OSDelegatingFileTailingMessageProducer.this.logger.isDebugEnabled()) {
                        OSDelegatingFileTailingMessageProducer.this.logger.debug((Object)"Exception on tail error reader", (Throwable)e);
                    }
                }
                finally {
                    block15: {
                        try {
                            errorReader.close();
                        }
                        catch (IOException e) {
                            if (!OSDelegatingFileTailingMessageProducer.this.logger.isDebugEnabled()) break block15;
                            OSDelegatingFileTailingMessageProducer.this.logger.debug((Object)"Exception while closing stderr", (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    public void run() {
        try {
            String line;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Reading stdout");
            }
            while ((line = this.reader.readLine()) != null) {
                this.send(line);
            }
        }
        catch (IOException e) {
            block7: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Exception on tail reader", (Throwable)e);
                }
                try {
                    this.reader.close();
                }
                catch (IOException e1) {
                    if (!this.logger.isDebugEnabled()) break block7;
                    this.logger.debug((Object)"Exception while closing stdout", (Throwable)e);
                }
            }
            this.destroyProcess();
        }
    }
}

