/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.inbound;

import java.io.File;
import java.io.IOException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.aws.support.S3Session;
import org.springframework.integration.aws.support.S3SessionFactory;
import org.springframework.integration.aws.support.filters.S3PersistentAcceptOnceFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.lang.Nullable;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3InboundFileSynchronizer
extends AbstractInboundFileSynchronizer<S3Object> {
    public S3InboundFileSynchronizer() {
        this(new S3SessionFactory());
    }

    public S3InboundFileSynchronizer(S3Client amazonS3) {
        this(new S3SessionFactory(amazonS3));
    }

    public S3InboundFileSynchronizer(SessionFactory<S3Object> sessionFactory) {
        super(sessionFactory);
        this.doSetRemoteDirectoryExpression((Expression)new LiteralExpression(null));
        this.doSetFilter((FileListFilter)new S3PersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "s3MessageSource"));
    }

    protected boolean isFile(S3Object file) {
        return true;
    }

    protected String getFilename(S3Object file) {
        return file != null ? file.key() : null;
    }

    protected long getModified(S3Object file) {
        return file.lastModified().getEpochSecond();
    }

    protected boolean copyFileToLocalDirectory(String remoteDirectoryPath, @Nullable EvaluationContext localFileEvaluationContext, S3Object remoteFile, File localDirectory, Session<S3Object> session) throws IOException {
        return super.copyFileToLocalDirectory(((S3Session)session).normalizeBucketName(remoteDirectoryPath), localFileEvaluationContext, (Object)remoteFile, localDirectory, session);
    }

    protected String protocol() {
        return "s3";
    }
}

