/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.outbound;

import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AmqpOutboundEndpoint
extends AbstractReplyProducingMessageHandler
implements RabbitTemplate.ConfirmCallback,
RabbitTemplate.ReturnCallback,
ApplicationListener<ContextRefreshedEvent> {
    private static final ExpressionParser expressionParser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private final AmqpTemplate amqpTemplate;
    private volatile boolean expectReply;
    private volatile String exchangeName;
    private volatile String routingKey;
    private volatile String exchangeNameExpression;
    private volatile String routingKeyExpression;
    private volatile ExpressionEvaluatingMessageProcessor<String> routingKeyGenerator;
    private volatile ExpressionEvaluatingMessageProcessor<String> exchangeNameGenerator;
    private volatile AmqpHeaderMapper headerMapper = new DefaultAmqpHeaderMapper();
    private volatile String confirmCorrelationExpression;
    private volatile ExpressionEvaluatingMessageProcessor<Object> correlationDataGenerator;
    private volatile MessageChannel confirmAckChannel;
    private volatile MessageChannel confirmNackChannel;
    private volatile MessageChannel returnChannel;
    private volatile MessageDeliveryMode defaultDeliveryMode;
    private volatile boolean lazyConnect = true;

    public AmqpOutboundEndpoint(AmqpTemplate amqpTemplate) {
        Assert.notNull((Object)amqpTemplate, (String)"amqpTemplate must not be null");
        this.amqpTemplate = amqpTemplate;
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setExchangeName(String exchangeName) {
        Assert.notNull((Object)exchangeName, (String)"exchangeName must not be null");
        this.exchangeName = exchangeName;
    }

    public void setExchangeNameExpression(String exchangeNameExpression) {
        this.exchangeNameExpression = exchangeNameExpression;
    }

    public void setRoutingKey(String routingKey) {
        Assert.notNull((Object)routingKey, (String)"routingKey must not be null");
        this.routingKey = routingKey;
    }

    public void setRoutingKeyExpression(String routingKeyExpression) {
        this.routingKeyExpression = routingKeyExpression;
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setConfirmCorrelationExpression(String confirmCorrelationExpression) {
        this.confirmCorrelationExpression = confirmCorrelationExpression;
    }

    public void setConfirmAckChannel(MessageChannel ackChannel) {
        this.confirmAckChannel = ackChannel;
    }

    public void setConfirmNackChannel(MessageChannel nackChannel) {
        this.confirmNackChannel = nackChannel;
    }

    public void setReturnChannel(MessageChannel returnChannel) {
        this.returnChannel = returnChannel;
    }

    public void setDefaultDeliveryMode(MessageDeliveryMode defaultDeliveryMode) {
        this.defaultDeliveryMode = defaultDeliveryMode;
    }

    public void setLazyConnect(boolean lazyConnect) {
        this.lazyConnect = lazyConnect;
    }

    public String getComponentType() {
        return this.expectReply ? "amqp:outbound-gateway" : "amqp:outbound-channel-adapter";
    }

    protected void doInit() {
        Expression expression;
        Assert.state((this.exchangeNameExpression == null || this.exchangeName == null ? 1 : 0) != 0, (String)"Either an exchangeName or an exchangeNameExpression can be provided, but not both");
        Assert.state((this.confirmCorrelationExpression == null || !this.expectReply ? 1 : 0) != 0, (String)"Confirm correlation expression does not apply to a gateway");
        BeanFactory beanFactory = this.getBeanFactory();
        if (this.exchangeNameExpression != null) {
            expression = expressionParser.parseExpression(this.exchangeNameExpression);
            this.exchangeNameGenerator = new ExpressionEvaluatingMessageProcessor(expression, String.class);
            if (beanFactory != null) {
                this.exchangeNameGenerator.setBeanFactory(beanFactory);
            }
        }
        Assert.state((this.routingKeyExpression == null || this.routingKey == null ? 1 : 0) != 0, (String)"Either a routingKey or a routingKeyExpression can be provided, but not both");
        if (this.routingKeyExpression != null) {
            expression = expressionParser.parseExpression(this.routingKeyExpression);
            this.routingKeyGenerator = new ExpressionEvaluatingMessageProcessor(expression, String.class);
            if (beanFactory != null) {
                this.routingKeyGenerator.setBeanFactory(beanFactory);
            }
        }
        if (this.confirmCorrelationExpression != null) {
            expression = expressionParser.parseExpression(this.confirmCorrelationExpression);
            this.correlationDataGenerator = new ExpressionEvaluatingMessageProcessor(expression, Object.class);
            Assert.isInstanceOf(RabbitTemplate.class, (Object)this.amqpTemplate, (String)"RabbitTemplate implementation is required for publisher confirms");
            ((RabbitTemplate)this.amqpTemplate).setConfirmCallback((RabbitTemplate.ConfirmCallback)this);
            if (beanFactory != null) {
                this.correlationDataGenerator.setBeanFactory(beanFactory);
            }
        } else {
            Assert.state((this.confirmAckChannel == null || this.confirmAckChannel instanceof NullChannel ? 1 : 0) != 0, (String)"A 'confirmCorrelationExpression' is required when specifying a 'confirmAckChannel'");
            Assert.state((this.confirmNackChannel == null || this.confirmNackChannel instanceof NullChannel ? 1 : 0) != 0, (String)"A 'confirmCorrelationExpression' is required when specifying a 'confirmNackChannel'");
        }
        if (this.returnChannel != null) {
            Assert.isInstanceOf(RabbitTemplate.class, (Object)this.amqpTemplate, (String)"RabbitTemplate implementation is required for publisher confirms");
            ((RabbitTemplate)this.amqpTemplate).setReturnCallback((RabbitTemplate.ReturnCallback)this);
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ConnectionFactory connectionFactory;
        if (!this.lazyConnect && event.getApplicationContext().equals(this.getApplicationContext()) && this.amqpTemplate instanceof RabbitTemplate && (connectionFactory = ((RabbitTemplate)this.amqpTemplate).getConnectionFactory()) != null) {
            try {
                Connection connection = connectionFactory.createConnection();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"Failed to eagerly establish the connection.", (Throwable)e);
            }
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Object userCorrelationData;
        String exchangeName = this.exchangeName;
        String routingKey = this.routingKey;
        Object correlationData = null;
        if (this.correlationDataGenerator != null && (userCorrelationData = this.correlationDataGenerator.processMessage(requestMessage)) != null) {
            correlationData = userCorrelationData instanceof CorrelationData ? (CorrelationData)userCorrelationData : new CorrelationDataWrapper(requestMessage.getHeaders().getId().toString(), userCorrelationData);
        }
        if (this.exchangeNameGenerator != null) {
            exchangeName = (String)this.exchangeNameGenerator.processMessage(requestMessage);
        }
        if (this.routingKeyGenerator != null) {
            routingKey = (String)this.routingKeyGenerator.processMessage(requestMessage);
        }
        if (this.expectReply) {
            return this.sendAndReceive(exchangeName, routingKey, requestMessage);
        }
        this.send(exchangeName, routingKey, requestMessage, (CorrelationData)correlationData);
        return null;
    }

    private void send(String exchangeName, String routingKey, final Message<?> requestMessage, CorrelationData correlationData) {
        if (this.amqpTemplate instanceof RabbitTemplate) {
            ((RabbitTemplate)this.amqpTemplate).convertAndSend(exchangeName, routingKey, requestMessage.getPayload(), new MessagePostProcessor(){

                public org.springframework.amqp.core.Message postProcessMessage(org.springframework.amqp.core.Message message) throws AmqpException {
                    AmqpOutboundEndpoint.this.headerMapper.fromHeadersToRequest(requestMessage.getHeaders(), message.getMessageProperties());
                    AmqpOutboundEndpoint.this.checkDeliveryMode(requestMessage, message.getMessageProperties());
                    return message;
                }
            }, correlationData);
        } else {
            this.amqpTemplate.convertAndSend(exchangeName, routingKey, requestMessage.getPayload(), new MessagePostProcessor(){

                public org.springframework.amqp.core.Message postProcessMessage(org.springframework.amqp.core.Message message) throws AmqpException {
                    AmqpOutboundEndpoint.this.headerMapper.fromHeadersToRequest(requestMessage.getHeaders(), message.getMessageProperties());
                    return message;
                }
            });
        }
    }

    private Message<?> sendAndReceive(String exchangeName, String routingKey, Message<?> requestMessage) {
        Assert.isInstanceOf(RabbitTemplate.class, (Object)this.amqpTemplate, (String)"RabbitTemplate implementation is required for publisher confirms");
        MessageConverter converter = ((RabbitTemplate)this.amqpTemplate).getMessageConverter();
        MessageProperties amqpMessageProperties = new MessageProperties();
        org.springframework.amqp.core.Message amqpMessage = converter.toMessage(requestMessage.getPayload(), amqpMessageProperties);
        this.headerMapper.fromHeadersToRequest(requestMessage.getHeaders(), amqpMessageProperties);
        this.checkDeliveryMode(requestMessage, amqpMessageProperties);
        org.springframework.amqp.core.Message amqpReplyMessage = this.amqpTemplate.sendAndReceive(exchangeName, routingKey, amqpMessage);
        if (amqpReplyMessage == null) {
            return null;
        }
        Object replyObject = converter.fromMessage(amqpReplyMessage);
        AbstractIntegrationMessageBuilder builder = replyObject instanceof Message ? this.getMessageBuilderFactory().fromMessage((Message)replyObject) : this.getMessageBuilderFactory().withPayload(replyObject);
        Map headers = this.headerMapper.toHeadersFromReply(amqpReplyMessage.getMessageProperties());
        builder.copyHeadersIfAbsent(headers);
        return builder.build();
    }

    private void checkDeliveryMode(Message<?> requestMessage, MessageProperties messageProperties) {
        if (this.defaultDeliveryMode != null && requestMessage.getHeaders().get((Object)"amqp_deliveryMode") == null) {
            messageProperties.setDeliveryMode(this.defaultDeliveryMode);
        }
    }

    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        Object userCorrelationData = correlationData;
        if (correlationData == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No correlation data provided for ack: " + ack + " cause:" + cause));
            }
            return;
        }
        if (correlationData instanceof CorrelationDataWrapper) {
            userCorrelationData = ((CorrelationDataWrapper)correlationData).getUserData();
        }
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("amqp_publishConfirm", ack);
        if (!ack && StringUtils.hasText((String)cause)) {
            headers.put("amqp_publishConfirmNackCause", cause);
        }
        Message confirmMessage = this.getMessageBuilderFactory().withPayload(userCorrelationData).copyHeaders(headers).build();
        if (ack && this.confirmAckChannel != null) {
            this.confirmAckChannel.send(confirmMessage);
        } else if (!ack && this.confirmNackChannel != null) {
            this.confirmNackChannel.send(confirmMessage);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Nowhere to send publisher confirm " + (ack ? "ack" : "nack") + " for " + userCorrelationData));
        }
    }

    public void returnedMessage(org.springframework.amqp.core.Message message, int replyCode, String replyText, String exchange, String routingKey) {
        MessageConverter converter = ((RabbitTemplate)this.amqpTemplate).getMessageConverter();
        Object returnedObject = converter.fromMessage(message);
        AbstractIntegrationMessageBuilder builder = returnedObject instanceof Message ? this.getMessageBuilderFactory().fromMessage((Message)returnedObject) : this.getMessageBuilderFactory().withPayload(returnedObject);
        Map headers = this.headerMapper.toHeadersFromReply(message.getMessageProperties());
        builder.copyHeadersIfAbsent(headers).setHeader("amqp_returnReplyCode", (Object)replyCode).setHeader("amqp_returnReplyText", (Object)replyText).setHeader("amqp_returnExchange", (Object)exchange).setHeader("amqp_returnRoutingKey", (Object)routingKey);
        this.returnChannel.send(builder.build());
    }

    private static class CorrelationDataWrapper
    extends CorrelationData {
        private final Object userData;

        public CorrelationDataWrapper(String id, Object userData) {
            super(id);
            this.userData = userData;
        }

        public Object getUserData() {
            return this.userData;
        }
    }
}

