/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.inbound;

import com.rabbitmq.client.Channel;
import java.util.Map;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AmqpInboundGateway
extends MessagingGatewaySupport {
    private final AbstractMessageListenerContainer messageListenerContainer;
    private volatile MessageConverter amqpMessageConverter = new SimpleMessageConverter();
    private volatile AmqpHeaderMapper headerMapper = new DefaultAmqpHeaderMapper();
    private final RabbitTemplate amqpTemplate;

    public AmqpInboundGateway(AbstractMessageListenerContainer listenerContainer) {
        Assert.notNull((Object)listenerContainer, (String)"listenerContainer must not be null");
        Assert.isNull((Object)listenerContainer.getMessageListener(), (String)"The listenerContainer provided to an AMQP inbound Gateway must not have a MessageListener configured since the adapter needs to configure its own listener implementation.");
        this.messageListenerContainer = listenerContainer;
        this.messageListenerContainer.setAutoStartup(false);
        this.amqpTemplate = new RabbitTemplate(this.messageListenerContainer.getConnectionFactory());
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"MessageConverter must not be null");
        this.amqpMessageConverter = messageConverter;
        this.amqpTemplate.setMessageConverter(messageConverter);
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public String getComponentType() {
        return "amqp:inbound-gateway";
    }

    protected void onInit() throws Exception {
        this.messageListenerContainer.setMessageListener((Object)new ChannelAwareMessageListener(){

            public void onMessage(org.springframework.amqp.core.Message message, Channel channel) {
                Message request;
                Message reply;
                Object payload = AmqpInboundGateway.this.amqpMessageConverter.fromMessage(message);
                Map headers = AmqpInboundGateway.this.headerMapper.toHeadersFromRequest(message.getMessageProperties());
                if (AmqpInboundGateway.this.messageListenerContainer.getAcknowledgeMode() == AcknowledgeMode.MANUAL) {
                    headers.put("amqp_deliveryTag", message.getMessageProperties().getDeliveryTag());
                    headers.put("amqp_channel", channel);
                }
                if ((reply = AmqpInboundGateway.this.sendAndReceiveMessage(request = AmqpInboundGateway.this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headers).build())) != null) {
                    Address replyTo = message.getMessageProperties().getReplyToAddress();
                    Assert.notNull((Object)replyTo, (String)"The replyTo header must not be null on a request Message being handled by the AMQP inbound gateway.");
                    AmqpInboundGateway.this.amqpTemplate.convertAndSend(replyTo.getExchangeName(), replyTo.getRoutingKey(), reply.getPayload(), new MessagePostProcessor(){

                        public org.springframework.amqp.core.Message postProcessMessage(org.springframework.amqp.core.Message message) throws AmqpException {
                            MessageProperties messageProperties = message.getMessageProperties();
                            String contentEncoding = messageProperties.getContentEncoding();
                            long contentLength = messageProperties.getContentLength();
                            String contentType = messageProperties.getContentType();
                            AmqpInboundGateway.this.headerMapper.fromHeadersToReply(reply.getHeaders(), messageProperties);
                            messageProperties.setReplyTo(null);
                            if (StringUtils.hasText((String)contentEncoding)) {
                                messageProperties.setContentEncoding(contentEncoding);
                            }
                            messageProperties.setContentLength(contentLength);
                            if (contentType != null) {
                                messageProperties.setContentType(contentType);
                            }
                            return message;
                        }
                    });
                }
            }
        });
        this.messageListenerContainer.afterPropertiesSet();
        this.amqpTemplate.afterPropertiesSet();
        super.onInit();
    }

    protected void doStart() {
        this.messageListenerContainer.start();
    }

    protected void doStop() {
        this.messageListenerContainer.stop();
    }
}

