/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.channel;

import java.util.ArrayDeque;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.integration.amqp.channel.AbstractAmqpChannel;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;
import org.springframework.util.Assert;

public class PollableAmqpChannel
extends AbstractAmqpChannel
implements PollableChannel {
    private final String channelName;
    private volatile String queueName;
    private volatile AmqpAdmin amqpAdmin;

    public PollableAmqpChannel(String channelName, AmqpTemplate amqpTemplate) {
        super(amqpTemplate);
        Assert.hasText((String)channelName, (String)"channel name must not be empty");
        this.channelName = channelName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setAmqpAdmin(AmqpAdmin amqpAdmin) {
        this.amqpAdmin = amqpAdmin;
    }

    protected void onInit() throws Exception {
        AmqpTemplate amqpTemplate = this.getAmqpTemplate();
        if (this.queueName == null) {
            if (this.amqpAdmin == null && amqpTemplate instanceof RabbitTemplate) {
                this.amqpAdmin = new RabbitAdmin(((RabbitTemplate)amqpTemplate).getConnectionFactory());
            }
            Assert.notNull((Object)this.amqpAdmin, (String)"If no queueName is configured explicitly, an AmqpAdmin instance must be provided, or the AmqpTemplate must be a RabbitTemplate since the Queue needs to be declared.");
            this.queueName = this.channelName;
            this.amqpAdmin.declareQueue(new Queue(this.queueName));
        }
    }

    @Override
    protected String getRoutingKey() {
        return this.queueName;
    }

    public Message<?> receive() {
        AbstractMessageChannel.ChannelInterceptorList interceptorList = this.getInterceptors();
        ArrayDeque interceptorStack = null;
        try {
            if (interceptorList.getInterceptors().size() > 0 && !interceptorList.preReceive((MessageChannel)this, interceptorStack = new ArrayDeque())) {
                return null;
            }
            Object object = this.getAmqpTemplate().receiveAndConvert(this.queueName);
            if (object == null) {
                return null;
            }
            Message message = null;
            message = object instanceof Message ? (Message)object : this.getMessageBuilderFactory().withPayload(object).build();
            message = interceptorList.postReceive(message, (MessageChannel)this);
            if (interceptorStack != null) {
                interceptorList.afterReceiveCompletion(message, (MessageChannel)this, null, interceptorStack);
            }
            return message;
        }
        catch (RuntimeException e) {
            if (interceptorStack != null) {
                interceptorList.afterReceiveCompletion(null, (MessageChannel)this, (Exception)e, interceptorStack);
            }
            throw e;
        }
    }

    public Message<?> receive(long timeout) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Calling receive with a timeout value on PollableAmqpChannel. The timeout will be ignored since no receive timeout is supported.");
        }
        return this.receive();
    }
}

