/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.aot;

import java.util.List;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;

class RepresentationModelRuntimeHints
implements RuntimeHintsRegistrar {
    private static final List<Class<?>> REPRESENTATION_MODELS = List.of(RepresentationModel.class, EntityModel.class, CollectionModel.class, PagedModel.class, PagedModel.PageMetadata.class);

    RepresentationModelRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        ReflectionHints reflection = hints.reflection();
        REPRESENTATION_MODELS.forEach(it -> reflection.registerType(it, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS}));
    }
}

