/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.config.WebClientConfigurer;
import org.springframework.lang.NonNull;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
class WebClientHateoasConfiguration {
    WebClientHateoasConfiguration() {
    }

    @Bean
    WebClientConfigurer webClientConfigurer(ObjectProvider<ObjectMapper> mapper, List<HypermediaMappingInformation> hypermediaTypes) {
        return new WebClientConfigurer((ObjectMapper)mapper.getIfAvailable(ObjectMapper::new), hypermediaTypes);
    }

    @Bean
    static HypermediaWebClientBeanPostProcessor webClientBeanPostProcessor(ObjectProvider<WebClientConfigurer> configurer) {
        return new HypermediaWebClientBeanPostProcessor(configurer);
    }

    static class HypermediaWebClientBeanPostProcessor
    implements BeanPostProcessor {
        private final ObjectProvider<WebClientConfigurer> configurer;

        @NonNull
        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof WebClient) {
                return ((WebClientConfigurer)this.configurer.getObject()).registerHypermediaTypes((WebClient)bean);
            }
            return bean;
        }

        @Generated
        public HypermediaWebClientBeanPostProcessor(ObjectProvider<WebClientConfigurer> configurer) {
            this.configurer = configurer;
        }
    }
}

