/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.net.URI;
import org.springframework.hateoas.Identifiable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkBuilder;
import org.springframework.hateoas.core.EncodingUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class LinkBuilderSupport<T extends LinkBuilder>
implements LinkBuilder {
    private final UriComponents uriComponents;

    public LinkBuilderSupport(UriComponentsBuilder builder) {
        Assert.notNull((Object)builder, (String)"UriComponentsBuilder must not be null!");
        this.uriComponents = builder.build();
    }

    public LinkBuilderSupport(UriComponents uriComponents) {
        Assert.notNull((Object)uriComponents, (String)"UriComponents must not be null!");
        this.uriComponents = uriComponents;
    }

    public T slash(Object object) {
        if (object == null) {
            return this.getThis();
        }
        if (object instanceof Identifiable) {
            return this.slash((Identifiable)object);
        }
        String path = object.toString();
        if (path.endsWith("#")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!StringUtils.hasText((String)path)) {
            return this.getThis();
        }
        path = path.startsWith("/") ? path : "/".concat(path);
        return this.slash(UriComponentsBuilder.fromUriString((String)path).build(), false);
    }

    protected T slash(UriComponents components, boolean encoded) {
        String uriString = this.uriComponents.toUriString();
        UriComponentsBuilder builder = uriString.isEmpty() ? UriComponentsBuilder.fromUri((URI)this.uriComponents.toUri()) : UriComponentsBuilder.fromUriString((String)uriString);
        for (String pathSegment : components.getPathSegments()) {
            builder.pathSegment(new String[]{encoded ? pathSegment : EncodingUtils.encodePath(pathSegment)});
        }
        String fragment = components.getFragment();
        if (StringUtils.hasText((String)fragment)) {
            builder.fragment(encoded ? fragment : EncodingUtils.encodeFragment(fragment));
        }
        return this.createNewInstance(builder.query(components.getQuery()));
    }

    public T slash(Identifiable<?> identifyable) {
        if (identifyable == null) {
            return this.getThis();
        }
        return this.slash(identifyable.getId());
    }

    @Override
    public URI toUri() {
        return this.uriComponents.encode().toUri().normalize();
    }

    @Override
    public Link withRel(String rel) {
        return new Link(this.toString(), rel);
    }

    @Override
    public Link withSelfRel() {
        return this.withRel("self");
    }

    public String toString() {
        return this.uriComponents.toUriString();
    }

    protected abstract T getThis();

    protected abstract T createNewInstance(UriComponentsBuilder var1);
}

