/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import java.util.Map;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.graphql.data.pagination.CursorStrategy;
import org.springframework.graphql.data.query.JsonKeysetCursorStrategy;
import org.springframework.util.Assert;

public final class ScrollPositionCursorStrategy
implements CursorStrategy<ScrollPosition> {
    private static final String OFFSET_PREFIX = "O_";
    private static final String KEYSET_PREFIX = "K_";
    private final CursorStrategy<Map<String, Object>> keysetCursorStrategy;

    public ScrollPositionCursorStrategy() {
        this(new JsonKeysetCursorStrategy());
    }

    public ScrollPositionCursorStrategy(CursorStrategy<Map<String, Object>> keysetCursorStrategy) {
        Assert.notNull(keysetCursorStrategy, (String)"'keysetCursorStrategy' is required");
        this.keysetCursorStrategy = keysetCursorStrategy;
    }

    @Override
    public boolean supports(Class<?> targetType) {
        return ScrollPosition.class.isAssignableFrom(targetType);
    }

    @Override
    public String toCursor(ScrollPosition position) {
        if (position instanceof OffsetScrollPosition) {
            OffsetScrollPosition offsetPosition = (OffsetScrollPosition)position;
            return OFFSET_PREFIX + offsetPosition.getOffset();
        }
        if (position instanceof KeysetScrollPosition) {
            KeysetScrollPosition keysetPosition = (KeysetScrollPosition)position;
            return KEYSET_PREFIX + this.keysetCursorStrategy.toCursor(keysetPosition.getKeys());
        }
        throw new IllegalArgumentException("Unexpected ScrollPosition type: " + position.getClass().getName());
    }

    @Override
    public ScrollPosition fromCursor(String cursor) {
        if (cursor.length() > 2) {
            try {
                if (cursor.startsWith(OFFSET_PREFIX)) {
                    long index = Long.parseLong(cursor.substring(2));
                    return ScrollPosition.offset((long)(index > 0L ? index : 0L));
                }
                if (cursor.startsWith(KEYSET_PREFIX)) {
                    Map<String, Object> keys = this.keysetCursorStrategy.fromCursor(cursor.substring(2));
                    return ScrollPosition.forward(keys);
                }
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Failed to parse cursor: " + cursor, ex);
            }
        }
        throw new IllegalArgumentException("Invalid or unknown cursor type: " + cursor);
    }
}

