/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryMetadata;
import org.springframework.graphql.data.GraphQlRepository;
import org.springframework.graphql.data.pagination.CursorEncoder;
import org.springframework.graphql.data.pagination.CursorStrategy;
import org.springframework.graphql.data.query.ScrollPositionCursorStrategy;
import org.springframework.graphql.data.query.ScrollSubrange;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class RepositoryUtils {
    private RepositoryUtils() {
    }

    static <T> Class<T> getDomainType(Object executor) {
        return RepositoryUtils.getRepositoryMetadata(executor).getDomainType();
    }

    static RepositoryMetadata getRepositoryMetadata(Object executor) {
        Type[] genericInterfaces;
        Assert.isInstanceOf(Repository.class, (Object)executor);
        for (Type genericInterface : genericInterfaces = executor.getClass().getGenericInterfaces()) {
            Class rawClass = ResolvableType.forType((Type)genericInterface).getRawClass();
            if (rawClass == null || MergedAnnotations.from((AnnotatedElement)rawClass).isPresent(NoRepositoryBean.class) || !Repository.class.isAssignableFrom(rawClass)) continue;
            return new DefaultRepositoryMetadata(rawClass);
        }
        throw new IllegalArgumentException(String.format("Cannot resolve repository interface from %s", executor));
    }

    static @Nullable String getGraphQlTypeName(Object repository) {
        GraphQlRepository annotation = (GraphQlRepository)AnnotatedElementUtils.findMergedAnnotation(repository.getClass(), GraphQlRepository.class);
        if (annotation == null) {
            return null;
        }
        return StringUtils.hasText((String)annotation.typeName()) ? annotation.typeName() : RepositoryUtils.getDomainType(repository).getSimpleName();
    }

    static CursorStrategy<ScrollPosition> defaultCursorStrategy() {
        return CursorStrategy.withEncoder(new ScrollPositionCursorStrategy(), CursorEncoder.base64());
    }

    static int defaultScrollCount() {
        return 20;
    }

    static Function<Boolean, ScrollPosition> defaultScrollPosition() {
        return forward -> ScrollPosition.offset();
    }

    static ScrollSubrange getScrollSubrange(DataFetchingEnvironment env, CursorStrategy<ScrollPosition> cursorStrategy) {
        boolean forward = true;
        String cursor = (String)env.getArgument("after");
        Integer count = (Integer)env.getArgument("first");
        if (cursor == null && count == null) {
            cursor = (String)env.getArgument("before");
            count = (Integer)env.getArgument("last");
            if (cursor != null || count != null) {
                forward = false;
            }
        }
        ScrollPosition pos = cursor != null ? cursorStrategy.fromCursor(cursor) : null;
        return ScrollSubrange.create(pos, count, forward);
    }
}

