/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.EncodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.SmartHttpMessageConverter;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class HttpMessageConverterDelegate {
    private HttpMessageConverterDelegate() {
    }

    static boolean isJsonConverter(HttpMessageConverter<?> converter) {
        return converter.canRead(Map.class, MediaType.APPLICATION_JSON);
    }

    static HttpMessageConverterEncoder asEncoder(HttpMessageConverter<Object> converter) {
        return new HttpMessageConverterEncoder(converter);
    }

    static HttpMessageConverterDecoder asDecoder(HttpMessageConverter<Object> converter) {
        return new HttpMessageConverterDecoder(converter);
    }

    private static @Nullable MediaType toMediaType(@Nullable MimeType mimeType) {
        if (mimeType instanceof MediaType) {
            MediaType mediaType = (MediaType)mimeType;
            return mediaType;
        }
        return mimeType != null ? new MediaType(mimeType) : null;
    }

    private static final class HttpMessageConverterEncoder
    implements Encoder<Object> {
        private final HttpMessageConverter<Object> converter;
        private final List<MimeType> mimeTypes;

        private HttpMessageConverterEncoder(HttpMessageConverter<Object> converter) {
            this.converter = converter;
            this.mimeTypes = new ArrayList<MimeType>(this.converter.getSupportedMediaTypes());
        }

        public List<MimeType> getEncodableMimeTypes() {
            return this.mimeTypes;
        }

        public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
            return this.converter.canWrite(elementType.resolve(Object.class), HttpMessageConverterDelegate.toMediaType(mimeType));
        }

        public DataBuffer encodeValue(Object value, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
            HttpOutputMessageAdapter messageAdapter = new HttpOutputMessageAdapter();
            try {
                HttpMessageConverter<Object> httpMessageConverter = this.converter;
                if (httpMessageConverter instanceof SmartHttpMessageConverter) {
                    SmartHttpMessageConverter smartConverter = (SmartHttpMessageConverter)httpMessageConverter;
                    smartConverter.write(value, valueType, HttpMessageConverterDelegate.toMediaType(mimeType), (HttpOutputMessage)messageAdapter, hints);
                } else {
                    httpMessageConverter = this.converter;
                    if (httpMessageConverter instanceof GenericHttpMessageConverter) {
                        GenericHttpMessageConverter genericConverter = (GenericHttpMessageConverter)httpMessageConverter;
                        genericConverter.write(value, valueType.getType(), HttpMessageConverterDelegate.toMediaType(mimeType), (HttpOutputMessage)messageAdapter);
                    } else {
                        this.converter.write(value, HttpMessageConverterDelegate.toMediaType(mimeType), (HttpOutputMessage)messageAdapter);
                    }
                }
                return bufferFactory.wrap(messageAdapter.toByteArray());
            }
            catch (IOException ex) {
                throw new EncodingException("Error while encoding: " + ex.getMessage(), (Throwable)ex);
            }
        }

        public Flux<DataBuffer> encode(Publisher<?> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class HttpMessageConverterDecoder
    implements Decoder<Object> {
        private final HttpMessageConverter<Object> converter;
        private final List<MimeType> mimeTypes;

        private HttpMessageConverterDecoder(HttpMessageConverter<Object> converter) {
            this.converter = converter;
            this.mimeTypes = new ArrayList<MimeType>(this.converter.getSupportedMediaTypes());
        }

        public List<MimeType> getDecodableMimeTypes() {
            return this.mimeTypes;
        }

        public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
            return this.converter.canRead(elementType.resolve(Object.class), HttpMessageConverterDelegate.toMediaType(mimeType));
        }

        public Object decode(DataBuffer buffer, ResolvableType targetType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) throws DecodingException {
            try {
                HttpInputMessageAdapter messageAdapter = new HttpInputMessageAdapter(buffer);
                HttpMessageConverter<Object> httpMessageConverter = this.converter;
                if (httpMessageConverter instanceof SmartHttpMessageConverter) {
                    SmartHttpMessageConverter smartConverter = (SmartHttpMessageConverter)httpMessageConverter;
                    return smartConverter.read(targetType, (HttpInputMessage)messageAdapter, hints);
                }
                httpMessageConverter = this.converter;
                if (httpMessageConverter instanceof GenericHttpMessageConverter) {
                    GenericHttpMessageConverter genericConverter = (GenericHttpMessageConverter)httpMessageConverter;
                    return genericConverter.read(targetType.getType(), null, (HttpInputMessage)messageAdapter);
                }
                return this.converter.read(targetType.resolve(Object.class), (HttpInputMessage)messageAdapter);
            }
            catch (IOException ex) {
                throw new DecodingException(ex.getMessage(), (Throwable)ex);
            }
        }

        public Mono<Object> decodeToMono(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
            throw new UnsupportedOperationException();
        }

        public Flux<Object> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class HttpOutputMessageAdapter
    extends ByteArrayOutputStream
    implements HttpOutputMessage {
        private static final HttpHeaders noOpHeaders = new HttpHeaders();

        private HttpOutputMessageAdapter() {
        }

        public OutputStream getBody() {
            return this;
        }

        public HttpHeaders getHeaders() {
            return noOpHeaders;
        }
    }

    private static final class HttpInputMessageAdapter
    extends ByteArrayInputStream
    implements HttpInputMessage {
        HttpInputMessageAdapter(DataBuffer buffer) {
            super(HttpInputMessageAdapter.toBytes(buffer));
        }

        private static byte[] toBytes(DataBuffer buffer) {
            byte[] bytes = new byte[buffer.readableByteCount()];
            buffer.read(bytes);
            DataBufferUtils.release((DataBuffer)buffer);
            return bytes;
        }

        public InputStream getBody() {
            return this;
        }

        public HttpHeaders getHeaders() {
            return HttpHeaders.EMPTY;
        }
    }
}

