/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.pagination.CursorStrategy;
import org.springframework.graphql.data.pagination.Subrange;
import org.springframework.util.Assert;

public class SubrangeMethodArgumentResolver<P>
implements HandlerMethodArgumentResolver {
    private final CursorStrategy<P> cursorStrategy;

    public SubrangeMethodArgumentResolver(CursorStrategy<P> cursorStrategy) {
        Assert.notNull(cursorStrategy, (String)"CursorStrategy is required");
        this.cursorStrategy = cursorStrategy;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().equals(Subrange.class) && this.cursorStrategy.supports(parameter.nested().getNestedParameterType());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) throws Exception {
        boolean forward = true;
        String cursor = (String)environment.getArgument("after");
        Integer count = (Integer)environment.getArgument("first");
        if (cursor == null && count == null) {
            cursor = (String)environment.getArgument("before");
            count = (Integer)environment.getArgument("last");
            if (cursor != null || count != null) {
                forward = false;
            }
        }
        P pos = cursor != null ? (P)this.cursorStrategy.fromCursor(cursor) : null;
        return this.createSubrange(pos, count, forward);
    }

    protected Subrange<P> createSubrange(@Nullable P pos, @Nullable Integer count, boolean forward) {
        return new Subrange<P>(pos, count, forward);
    }
}

