/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.FieldCoordinates;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.data.method.HandlerMethod;

public final class DataFetcherMappingInfo {
    private final FieldCoordinates coordinates;
    private final boolean batchMapping;
    private final int maxBatchSize;
    private final HandlerMethod handlerMethod;

    public DataFetcherMappingInfo(String typeName, String field, boolean batchMapping, int maxBatchSize, HandlerMethod handlerMethod) {
        this.coordinates = FieldCoordinates.coordinates((String)typeName, (String)field);
        this.batchMapping = batchMapping;
        this.maxBatchSize = maxBatchSize;
        this.handlerMethod = handlerMethod;
    }

    public DataFetcherMappingInfo(String typeName, DataFetcherMappingInfo info) {
        this.coordinates = FieldCoordinates.coordinates((String)typeName, (String)info.getCoordinates().getFieldName());
        this.batchMapping = info.batchMapping;
        this.maxBatchSize = info.maxBatchSize;
        this.handlerMethod = info.handlerMethod;
    }

    public FieldCoordinates getCoordinates() {
        return this.coordinates;
    }

    public String getTypeName() {
        return this.coordinates.getTypeName();
    }

    public String getFieldName() {
        return this.coordinates.getFieldName();
    }

    public boolean isBatchMapping() {
        return this.batchMapping;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataFetcherMappingInfo)) {
            return false;
        }
        DataFetcherMappingInfo otherInfo = (DataFetcherMappingInfo)other;
        return this.coordinates.equals((Object)otherInfo.coordinates);
    }

    public int hashCode() {
        return this.getCoordinates().hashCode() * 31;
    }

    public String toString() {
        return String.valueOf(this.coordinates) + " -> " + String.valueOf(this.getHandlerMethod());
    }
}

