/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server;

import io.micrometer.context.ContextSnapshot;
import io.micrometer.context.ContextSnapshotFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.execution.ContextPropagationHelper;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.graphql.server.WebSocketGraphQlInterceptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

class DefaultWebGraphQlHandlerBuilder
implements WebGraphQlHandler.Builder {
    private final ExecutionGraphQlService service;
    private final List<WebGraphQlInterceptor> interceptors = new ArrayList<WebGraphQlInterceptor>();
    @Nullable
    private ContextSnapshotFactory snapshotFactory;
    @Nullable
    private WebSocketGraphQlInterceptor webSocketInterceptor;

    DefaultWebGraphQlHandlerBuilder(ExecutionGraphQlService service) {
        Assert.notNull((Object)service, (String)"GraphQlService is required");
        this.service = service;
    }

    @Override
    public WebGraphQlHandler.Builder interceptor(WebGraphQlInterceptor ... interceptors) {
        return this.interceptors(Arrays.asList(interceptors));
    }

    @Override
    public WebGraphQlHandler.Builder interceptors(List<WebGraphQlInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        interceptors.forEach(interceptor -> {
            if (interceptor instanceof WebSocketGraphQlInterceptor) {
                Assert.isNull((Object)this.webSocketInterceptor, (String)"There can be at most 1 WebSocketInterceptor");
                this.webSocketInterceptor = (WebSocketGraphQlInterceptor)interceptor;
            }
        });
        return this;
    }

    @Override
    public WebGraphQlHandler.Builder contextSnapshotFactory(ContextSnapshotFactory snapshotFactory) {
        this.snapshotFactory = snapshotFactory;
        return this;
    }

    @Override
    public WebGraphQlHandler build() {
        final ContextSnapshotFactory snapshotFactory = ContextPropagationHelper.selectInstance(this.snapshotFactory);
        WebGraphQlInterceptor.Chain endOfChain = request -> this.service.execute(request).map(WebGraphQlResponse::new);
        final WebGraphQlInterceptor.Chain executionChain = this.interceptors.stream().reduce(WebGraphQlInterceptor::andThen).map(interceptor -> interceptor.apply(endOfChain)).orElse(endOfChain);
        return new WebGraphQlHandler(){
            final /* synthetic */ DefaultWebGraphQlHandlerBuilder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public WebSocketGraphQlInterceptor getWebSocketInterceptor() {
                return this.this$0.webSocketInterceptor != null ? this.this$0.webSocketInterceptor : new WebSocketGraphQlInterceptor(){};
            }

            @Override
            public ContextSnapshotFactory contextSnapshotFactory() {
                return snapshotFactory;
            }

            @Override
            public Mono<WebGraphQlResponse> handleRequest(WebGraphQlRequest request) {
                ContextSnapshot snapshot = snapshotFactory.captureAll(new Object[0]);
                return executionChain.next(request).contextWrite(context -> {
                    context = ContextPropagationHelper.saveInstance(snapshotFactory, context);
                    return (Context)snapshot.updateContext(context);
                });
            }
        };
    }
}

