/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Valid;
import jakarta.validation.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.BiConsumer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

final class ValidationHelper {
    private final Validator validator;

    private ValidationHelper(Validator validator) {
        Assert.notNull((Object)validator, (String)"Validator is required");
        this.validator = validator;
    }

    @Nullable
    BiConsumer<Object, Object[]> getValidationHelperFor(HandlerMethod handlerMethod) {
        HandlerMethodValidator result;
        boolean requiresMethodValidation = false;
        Class[] methodValidationGroups = null;
        Validated validatedAnnotation = this.findAnnotation(handlerMethod, Validated.class);
        if (validatedAnnotation != null) {
            requiresMethodValidation = true;
            methodValidationGroups = validatedAnnotation.value();
        } else if (this.findAnnotation(handlerMethod, Valid.class) != null) {
            requiresMethodValidation = true;
        }
        MethodParameterValidator parameterValidator = null;
        MethodParameter[] parameters = handlerMethod.getMethodParameters();
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter parameter = parameters[i];
            for (Annotation annot : parameter.getParameterAnnotations()) {
                MergedAnnotations merged = MergedAnnotations.from((Annotation[])new Annotation[]{annot});
                if (merged.isPresent(Valid.class) || merged.isPresent(Constraint.class)) {
                    requiresMethodValidation = true;
                    continue;
                }
                if (!annot.annotationType().equals(Validated.class)) continue;
                Class[] groups = ((Validated)annot).value();
                parameterValidator = parameterValidator != null ? parameterValidator.andThen(new MethodParameterValidator(i, groups)) : new MethodParameterValidator(i, groups);
            }
        }
        HandlerMethodValidator handlerMethodValidator = result = requiresMethodValidation ? new HandlerMethodValidator(handlerMethod, methodValidationGroups) : null;
        if (parameterValidator != null) {
            return result != null ? result.andThen(parameterValidator) : parameterValidator;
        }
        return result;
    }

    @Nullable
    private <A extends Annotation> A findAnnotation(HandlerMethod method, Class<A> annotationType) {
        Annotation annotation = AnnotationUtils.findAnnotation((Method)method.getMethod(), annotationType);
        if (annotation == null) {
            annotation = AnnotationUtils.findAnnotation(method.getBeanType(), annotationType);
        }
        return (A)annotation;
    }

    @Nullable
    static ValidationHelper createIfValidatorPresent(ApplicationContext context) {
        Validator validator = (Validator)context.getBeanProvider(Validator.class).getIfAvailable();
        try {
            if (validator instanceof LocalValidatorFactoryBean) {
                validator = ((LocalValidatorFactoryBean)validator).getValidator();
            } else if (validator instanceof SpringValidatorAdapter) {
                validator = (Validator)validator.unwrap(Validator.class);
            }
        }
        catch (Exception exc) {
            return null;
        }
        return validator != null ? ValidationHelper.create(validator) : null;
    }

    static ValidationHelper create(Validator validator) {
        return new ValidationHelper(validator);
    }

    private class MethodParameterValidator
    implements BiConsumer<Object, Object[]> {
        private final int index;
        private final Class<?>[] validationGroups;

        MethodParameterValidator(@Nullable int index, Class<?>[] validationGroups) {
            this.index = index;
            this.validationGroups = validationGroups != null ? validationGroups : new Class[]{};
        }

        @Override
        public void accept(Object controller, Object[] arguments) {
            Set violations = ValidationHelper.this.validator.validate(arguments[this.index], (Class[])this.validationGroups);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
    }

    private class HandlerMethodValidator
    implements BiConsumer<Object, Object[]> {
        private final Method method;
        private final Class<?>[] validationGroups;

        HandlerMethodValidator(@Nullable HandlerMethod handlerMethod, Class<?>[] validationGroups) {
            Assert.notNull((Object)handlerMethod, (String)"HandlerMethod is required");
            this.method = handlerMethod.getMethod();
            this.validationGroups = validationGroups != null ? validationGroups : new Class[]{};
        }

        @Override
        public void accept(Object controller, Object[] arguments) {
            Set violations = ValidationHelper.this.validator.forExecutables().validateParameters(controller, this.method, arguments, (Class[])this.validationGroups);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
    }
}

