/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.GraphQLContext;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.core.MethodParameter;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.LocalContextValue;
import org.springframework.graphql.data.method.annotation.support.ContextValueMethodArgumentResolver;
import org.springframework.util.Assert;

public class LocalContextValueMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterAnnotation(LocalContextValue.class) != null;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) {
        LocalContextValue annotation = (LocalContextValue)parameter.getParameterAnnotation(LocalContextValue.class);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)"Expected @LocalContextValue annotation");
        String name = ContextValueMethodArgumentResolver.getContextValueName(parameter, annotation.name(), annotation);
        Object localContext = environment.getLocalContext();
        Assert.state((localContext == null || localContext instanceof GraphQLContext ? 1 : 0) != 0, (String)"Local context is not an instance of  graphql.GraphQLContext");
        return ContextValueMethodArgumentResolver.resolveContextValue(name, annotation.required(), parameter, (GraphQLContext)localContext);
    }
}

