/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.graphql.execution.ErrorType;
import org.springframework.graphql.execution.SubscriptionExceptionResolver;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class CompositeSubscriptionExceptionResolver
implements SubscriptionExceptionResolver {
    private static final Log logger = LogFactory.getLog(CompositeSubscriptionExceptionResolver.class);
    private final List<SubscriptionExceptionResolver> resolvers;

    CompositeSubscriptionExceptionResolver(List<SubscriptionExceptionResolver> resolvers) {
        Assert.notNull(resolvers, (String)"'resolvers' is required");
        this.resolvers = resolvers;
    }

    @Override
    public Mono<List<GraphQLError>> resolveException(Throwable exception) {
        return Flux.fromIterable(this.resolvers).flatMap(resolver -> resolver.resolveException(exception)).next().onErrorResume(error -> Mono.just(this.handleResolverException((Throwable)error, exception))).defaultIfEmpty(this.createDefaultError());
    }

    private List<GraphQLError> handleResolverException(Throwable resolverException, Throwable originalException) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Failure while resolving " + originalException.getClass().getName()), resolverException);
        }
        return this.createDefaultError();
    }

    private List<GraphQLError> createDefaultError() {
        return Collections.singletonList(GraphqlErrorBuilder.newError().message("Subscription error", new Object[0]).errorType((ErrorClassification)ErrorType.INTERNAL_ERROR).build());
    }
}

