/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webflux;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.ResponseError;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.graphql.server.support.SerializableGraphQlRequest;
import org.springframework.graphql.server.webflux.HttpCodecDelegate;
import org.springframework.http.HttpCookie;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import reactor.core.publisher.Mono;

public abstract class AbstractGraphQlHttpHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final WebGraphQlHandler graphQlHandler;
    @Nullable
    private final HttpCodecDelegate codecDelegate;

    protected AbstractGraphQlHttpHandler(WebGraphQlHandler graphQlHandler, @Nullable CodecConfigurer codecConfigurer) {
        Assert.notNull((Object)graphQlHandler, (String)"WebGraphQlHandler is required");
        this.graphQlHandler = graphQlHandler;
        this.codecDelegate = codecConfigurer != null ? new HttpCodecDelegate(codecConfigurer) : null;
    }

    public Mono<ServerResponse> handleRequest(ServerRequest request) {
        return this.readRequest(request).flatMap(body -> {
            WebGraphQlRequest graphQlRequest = new WebGraphQlRequest(request.uri(), request.headers().asHttpHeaders(), (MultiValueMap<String, HttpCookie>)request.cookies(), (InetSocketAddress)request.remoteAddress().orElse(null), (Map<String, Object>)request.attributes(), (GraphQlRequest)body, request.exchange().getRequest().getId(), request.exchange().getLocaleContext().getLocale());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing: " + String.valueOf(graphQlRequest)));
            }
            return this.graphQlHandler.handleRequest(graphQlRequest);
        }).flatMap(response -> {
            if (this.logger.isDebugEnabled()) {
                List<ResponseError> errors = response.getErrors();
                this.logger.debug((Object)("Execution result " + (String)(!CollectionUtils.isEmpty(errors) ? "has errors: " + String.valueOf(errors) : "is ready") + "."));
            }
            return this.prepareResponse(request, (WebGraphQlResponse)response);
        });
    }

    private Mono<SerializableGraphQlRequest> readRequest(ServerRequest serverRequest) {
        if (this.codecDelegate != null) {
            MediaType contentType;
            ServerRequest.Headers headers = serverRequest.headers();
            try {
                contentType = headers.contentType().orElse(MediaType.APPLICATION_OCTET_STREAM);
            }
            catch (InvalidMediaTypeException ex2) {
                throw new UnsupportedMediaTypeStatusException("Could not parse Content-Type [" + headers.firstHeader("Content-Type") + "]: " + ex2.getMessage());
            }
            return this.codecDelegate.decode((Publisher<DataBuffer>)serverRequest.bodyToFlux(DataBuffer.class), contentType);
        }
        return serverRequest.bodyToMono(SerializableGraphQlRequest.class).onErrorResume(UnsupportedMediaTypeStatusException.class, ex -> AbstractGraphQlHttpHandler.applyApplicationGraphQlFallback(ex, serverRequest));
    }

    private static Mono<SerializableGraphQlRequest> applyApplicationGraphQlFallback(UnsupportedMediaTypeStatusException ex, ServerRequest request) {
        String contentTypeHeader = request.headers().firstHeader("Content-Type");
        if (StringUtils.hasText((String)contentTypeHeader)) {
            MediaType contentType = MediaType.parseMediaType((String)contentTypeHeader);
            MediaType applicationGraphQl = MediaType.parseMediaType((String)"application/graphql");
            return applicationGraphQl.includes(contentType) ? ServerRequest.from((ServerRequest)request).headers(headers -> headers.setContentType(MediaType.APPLICATION_JSON)).body(request.bodyToFlux(DataBuffer.class)).build().bodyToMono(SerializableGraphQlRequest.class).log() : Mono.error((Throwable)ex);
        }
        return Mono.error((Throwable)ex);
    }

    protected abstract Mono<ServerResponse> prepareResponse(ServerRequest var1, WebGraphQlResponse var2);

    protected Object encodeResponseIfNecessary(WebGraphQlResponse response) {
        DataBuffer resultMap = response.toMap();
        return this.codecDelegate != null ? this.encode((Map<String, Object>)resultMap) : resultMap;
    }

    protected DataBuffer encode(Map<String, Object> resultMap) {
        Assert.state((this.codecDelegate != null ? 1 : 0) != 0, (String)"CodecConfigurer was not provided");
        return this.codecDelegate.encode(resultMap);
    }
}

